% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feat.R
\name{convert.coords.feat}
\alias{convert.coords.feat}
\title{Convert coordinates from one frame of reference to another}
\usage{
convert.coords.feat(x, align, from = -1, to = 1)
}
\arguments{
\item{x}{A features object; if the from parameter is -1, the first
column should indicate which frame of reference is used for that row
(ie, the species name).
For coordinates in the frame of reference of the entire alignment, set
the first column to "MSA".}

\item{align}{An msa object containing the alignment}

\item{from}{A single character string or integer, used to indicate the
current frame of reference of the features.  If the rows of the features are
not all in the same frame of reference, set this to -1 and indicate the
frame of reference in the 1st column of the features.  Otherwise, it can
be specified here as a single integer (from 0 to nrow.msa(align)), with
0 indicating the frame of reference of the entire alignment, and 1
indicating the 1st species, 2 the second, etc.  Or it can be a single
character string giving the name of the species, with "MSA" indicating
the entire alignment.}

\item{to}{A single character string or integer, used to indicate the frame
of reference to convert to.  This is specified in the same way as the
"from" argument, above, except that -1 is not an option.}
}
\value{
A features object with elements in the frame of refernece
indicated by the "to" argument.
}
\description{
Converts coordinates of features in a GFF according to a multiple
alignment.  Will map from the coordinate system of any sequence
to any other sequence; can also map to or from the coordinate system
of the entire alignment.
}
\note{
Ignores any offset in MSA.  All coordinates should start with the
first position in the alignment as 1.

If the endpoints of an element have gaps in the "to" species,
the elements will be truncated
}
\examples{
require("rphast")
align <- msa(seqs=c("A-GTAT", "-GGTAA", "AG--AG"),
             names=c("human", "mouse", "rat"))
feats <- feat(seqname=c("MSA", "human", "human", "mouse", "mouse", "rat"),
              start=c(1, 2, 3, 1, 3, 3),
              end=c(6, 4, 4, 4, 5, 3))
convert.coords.feat(feats, align)  # convert everything to human coords
convert.coords.feat(feats, align, to="MSA")  # convert to alignment coords

# here, there is no position 6 in human alignment so feature is removed
convert.coords.feat(feat(seqname="human", start=6, end=6),
                    align, to="MSA")

# here, feature goes beyond end of MSA so it is truncated:
convert.coords.feat(feat(seqname="rat", start=2, end=100),
                    align, to="MSA")


# note that if the "to" species has gaps at the endpoints, they will
# be truncated:
align <- msa(seqs=c("A-GT-T", "ACGTGT"), names=c("human", "mouse"))
convert.coords.feat(feat(seqname="mouse", start=2, end=5),
                    align, to="human")
}
\author{
Melissa J. Hubisz and Adam Siepel
}

