% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{noise}
\alias{noise}
\title{Add noise to a time series}
\usage{
noise(input, type, final_level)
}
\arguments{
\item{input}{Time series to which noise will be added}

\item{type}{String. Defines what type of noise to be added. Acceptable values are:\itemize{
   \item{\code{white} - white noise with variance \code{final_level}}
   \item{\code{red} - red noise with variance \code{final_level} (use with caution)}
}}

\item{final_level}{Number or \code{var}.
A number sets the standard deviation to a constant value at each point.
\code{var} sets the standard deviation to increase proportional to the (absolute value of the) signal at peaks.}
}
\value{
Time series with added noise.
}
\description{
This function lets you add artificial noise to time series, normally to patterns generated by \link{generator}.
Use different types and strengths of noise to test smoothers.
}
\details{
For an overview of the package capabilities, click here \link{rpatrec}
}
\examples{
\dontrun{
#Generate a HS patterns
a <- generator()
#now add white noise with a standdard deviation of 10
b <- noise(a,'white',10)
plot(b)
}

}
