% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lists.R
\name{create_xref_whitelist}
\alias{create_xref_whitelist}
\title{Cross reference a whitelist of packages to a vulnerability database}
\usage{
create_xref_whitelist(packages, ecosystem, output_format = NULL)
}
\arguments{
\item{packages}{Character vector of package names.}

\item{ecosystem}{Character vector of ecosystem(s) within which the package(s) exist.}

\item{output_format}{Type of output to create (default is \code{NULL} for a \code{\link[base]{data.frame}}).}
}
\value{
A \code{\link[base]{data.frame}} or character vector containing cross-referenced packages.
}
\description{
Search for package names for vulnerability information and selectively drop packages
or define specific versions that should not be used in a curated repository.
}
\details{
Note that some version suffixes may have compatibility issues. For example, the use of
*-git as a suffix may not be recognized and may need to be dropped. For more details on
PyPI package version naming see \url{https://peps.python.org/pep-0440/}.

Due to variations in formatting from the OSV API, not all responses have versions associated and
are not directly compatible with this function.

Although the default output is a \code{\link[base]{data.frame}}, for PyPI packages a \code{requirements.txt} format can be
created that defines which versions should not be allowed based upon the cross-referencing performed. This can be
useful when curating repositories in Posit Package Manager.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Return xref dataset for CRAN package selection
cran_pkg <- c('readxl', 'dplyr')
cran_xref <- create_xref_whitelist(cran_pkg, ecosystem = 'CRAN')

# Create a requirements.txt with excluded versions
python_pkgs <- c('dask', 'aaiohttp', 'keras')
xref_pkg_list <- create_xref_whitelist(python_pkgs,
                                       ecosystem = 'PyPI',
                                       output_format = 'requirements.txt')
file_name <- file.path(tempdir(), 'requirements.txt')
writeLines(xref_pkg_list, file_name)

# Clean up
try(unlink(file_name))
\dontshow{\}) # examplesIf}
}
\seealso{
\href{https://packaging.python.org/en/latest/specifications/name-normalization/}{PyPI package normalization}
}
