% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_1.R
\name{osv_query_1}
\alias{osv_query_1}
\alias{.osv_query_1}
\alias{.osv_query_1_cache}
\title{Query OSV API for vulnerabilities based upon an individual package}
\usage{
osv_query_1(
  name = NULL,
  version = NULL,
  ecosystem = NULL,
  commit = NULL,
  purl = NULL,
  page_token = NA,
  parse = TRUE,
  cache = TRUE,
  ...
)

.osv_query_1(
  name = NULL,
  version = NULL,
  ecosystem = NULL,
  commit = NULL,
  purl = NULL,
  page_token = NA,
  parse = TRUE,
  cache = TRUE,
  ...
)

.osv_query_1_cache(
  name = NULL,
  version = NULL,
  ecosystem = NULL,
  commit = NULL,
  purl = NULL,
  page_token = NA,
  parse = TRUE,
  cache = TRUE,
  ...
)
}
\arguments{
\item{name}{Name of package.}

\item{version}{Version of package.}

\item{ecosystem}{Ecosystem package lives within (must be set if using \code{name}).}

\item{commit}{Commit hash to query against (do not use when version set).}

\item{purl}{URL for package (do not use if name or ecosystem set).}

\item{page_token}{When large number of results, next response to complete set requires a page_token.}

\item{parse}{Boolean value to set if the content field should be parsed from JSON list format.}

\item{cache}{Boolean value to determine if should use a cached version of the function and API results.}

\item{...}{Additional parameters passed to nested functions.}
}
\value{
An R6 object containing API query contents.
}
\description{
Query the OSV API for vulnerabilities that include the individual package of interest.
The request is automatically constructed from the provided elements and the returned
values are parsed into a \code{data.frame}.
}
\section{Functions}{
\itemize{
\item \code{.osv_query_1()}: Internal function to run \code{osv_query_1} without caching.

\item \code{.osv_query_1_cache()}: Internal function to run a memoise and cached version of \code{osv_query_1}.

}}
\examples{
osv_query_1(commit = '6879efc2c1596d11a6a6ad296f80063b558d5e0f')

}
\seealso{
\href{https://ossf.github.io/osv-schema/#affectedpackage-field}{Ecosystem list}
}
