% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{is_pkg_vulnerable}
\alias{is_pkg_vulnerable}
\title{Detect if package within ecosystem has reported vulnerabilities}
\usage{
is_pkg_vulnerable(name, ecosystem, ...)
}
\arguments{
\item{name}{Character vector of package names..}

\item{ecosystem}{Character vector of ecosystem(s) within which the package(s) exist.}

\item{...}{Any other parameters to pass to nested functions.}
}
\value{
A named vector of logical values.
}
\description{
Search the OSV database, by package name and its respective ecosystem, to determine
if a vulnerability has ever been listed. If a package has been listed as impacted by
a vulnerability this may warrant further queries to investigate specific versions
that have been affected.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
is_pkg_vulnerable(c('dask', 'dplyr'), c('PyPI', 'CRAN'))
\dontshow{\}) # examplesIf}
}
