% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggScatterPlot.R
\name{ggScatterPlot}
\alias{ggScatterPlot}
\title{Bar chart using ggplot}
\usage{
ggScatterPlot(
  x,
  y,
  jitter = TRUE,
  size = 3,
  alpha = 0.66,
  shape = 16,
  color = "black",
  fill = "black",
  stroke = 1,
  plotTheme = ggplot2::theme_bw(),
  ...
)
}
\arguments{
\item{x, y}{The vectors to display in the scatter plot. Alternatively,
\code{x} can be a data frame; then \code{y} has to be a vector with (numeric or
character) indices, e.g. column names.}

\item{jitter}{Whether to jitter the points (\code{TRUE} by default).}

\item{size, alpha, shape, color, fill, stroke}{Quick way to set the aesthetics.}

\item{plotTheme}{The theme to apply.}

\item{\dots}{And additional arguments are passed to \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot is returned.
}
\description{
This function provides a simple interface to create a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
bar chart.
}
\examples{
rosetta::ggScatterPlot(mtcars$hp, mtcars$mpg);

}
\seealso{
\code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}
}
