## ----echo=FALSE----------------------------------------------------------
knitr::opts_chunk$set(
	comment = "#>",
	collapse = TRUE,
	warning = FALSE,
	message = FALSE
)

## ----eval=FALSE----------------------------------------------------------
#  install.packages("rorcid")

## ----eval=FALSE----------------------------------------------------------
#  devtools::install_github("ropensci/rorcid")

## ------------------------------------------------------------------------
library("rorcid")

## ------------------------------------------------------------------------
as.orcid(x = "0000-0002-1642-628X")

## ------------------------------------------------------------------------
as.orcid(c("0000-0003-1620-1408", "0000-0002-9341-7985"))

## ----eval=FALSE----------------------------------------------------------
#  browse(as.orcid("0000-0002-1642-628X"))

## ------------------------------------------------------------------------
(out <- works(orcid_id("0000-0002-0233-1757")))

## ------------------------------------------------------------------------
out$data

## ------------------------------------------------------------------------
orcid(query = "carl boettiger")

## ------------------------------------------------------------------------
orcid(query = "johnson cardiology houston")

## ------------------------------------------------------------------------
orcid("johnson cardiology houston", start = 2, rows = 3)

## ------------------------------------------------------------------------
out <- orcid_id(orcid = "0000-0002-9341-7985")
out$`0000-0002-9341-7985`$`orcid-identifier`

## ------------------------------------------------------------------------
out <- orcid_id(orcid = "0000-0002-9341-7985", profile = "works")
out$`0000-0002-9341-7985`$`orcid-history`

## ----eval=FALSE----------------------------------------------------------
#  ids <- c("0000-0003-1620-1408", "0000-0002-9341-7985")
#  lapply(orcid_id(orcid = ids), "[[", "orcid-identifier")

## ------------------------------------------------------------------------
dois <- c("10.1371/journal.pone.0025995","10.1371/journal.pone.0053712",
       "10.1371/journal.pone.0054608","10.1371/journal.pone.0055937")
check_dois(dois)

## ------------------------------------------------------------------------
dois <- c("10.1016/j.medpal.2008.12.005","10.1080/00933104.2000.10505926","10.1037/a0024480",
        "10.1002/anie.196603172","2344","asdf","232","asdf","23dd")
check_dois(dois)

## ------------------------------------------------------------------------
orcid_doi(dois = "10.1087/20120404")

## ------------------------------------------------------------------------
orcid_doi(dois = "10.1087/2", fuzzy = TRUE, rows = 5)

## ------------------------------------------------------------------------
dois <- c("10.1371/journal.pone.0025995","10.1371/journal.pone.0053712",
       "10.1371/journal.pone.0054608","10.1371/journal.pone.0055937")
res <- orcid_doi(dois = dois, fuzzy = TRUE)
res[[1]]

