% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R
\name{\%~=\%}
\alias{\%~=\%}
\alias{\%ni\%}
\alias{\%xor\%}
\alias{\%aon\%}
\alias{\%><\%}
\alias{\%>=<\%}
\title{Logical operators}
\usage{
x \%~=\% y

x \%ni\% y

x \%xor\% y

x \%aon\% y

x \%><\% y

x \%>=<\% y
}
\arguments{
\item{x}{a vector}

\item{y}{a vector}
}
\description{
Logical operators

Not in

exclusive or

All or nothing

between (ends excluded)

between (ends included)
}
\examples{

#### Floating point test of equality ####
 (0.1 + 0.1 + 0.1) == 0.3   # FALSE

 (0.1 + 0.1 + 0.1) \%~=\% 0.3 # TRUE

 # NOTE parentheses surrounding expression before this operator are necessary
 # Without parentheses it would be interpreted as .1 + .1 + (.1 \%~=\% .3)


 #### Not in ####

 "z" \%ni\%  c("a", "b", "c")
 #  TRUE

 #### Exclusive or  ####

 TRUE \%xor\% TRUE
 # FALSE

 FALSE \%xor\% FALSE
 # FALSE

 FALSE \%xor\% TRUE
 # TRUE

 #### All-or-nothing ####

 TRUE \%aon\% TRUE
 # TRUE

 FALSE \%aon\% FALSE
 # TRUE

 FALSE \%aon\% TRUE
 # FALSE

 #### Between ####

 # ends excluded

 2 \%><\% c(1, 3)
 # TRUE

 3 \%><\% c(1, 3)
 # FALSE

 # ends included

 2 \%>=<\% c(1, 3)
 # TRUE

 3 \%>=<\% c(1, 3)
 # TRUE

}
