% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{format_names_for_plotting}
\alias{format_names_for_plotting}
\title{Format Names for Plotting}
\usage{
format_names_for_plotting(chars, width = 40, truncate_at = 80)
}
\arguments{
\item{chars}{a character vector (or a variable that can be converted to one)}

\item{width}{Positive integer giving target line width (in number of
characters). A width less than or equal to 1 will put each word on its
own line.}

\item{truncate_at}{max character length}
}
\value{
a reformatted character vector of the same length as the input.
}
\description{
Wrap long names over multiple lines so that they will look better on plots.
}
\examples{
chars <- "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer
  ac arcu semper erat porttitor egestas. Etiam sagittis, sapien at mattis."

format_names_for_plotting(chars)
}
