% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_sd}
\alias{roll_sd}
\title{Rolling Standard Deviations}
\usage{
roll_sd(x, width, weights = rep(1, width), center = TRUE,
  min_obs = width, complete_obs = FALSE, na_restore = FALSE,
  online = TRUE)
}
\arguments{
\item{x}{vector or matrix. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{weights}{vector. Weights for each observation within a window.}

\item{center}{logical. If \code{TRUE} then the weighted mean of each variable is used,
if \code{FALSE} then zero is used.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then each value is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{online}{logical. Process observations using an online algorithm.}
}
\value{
An object of the same class and dimension as \code{x} with the rolling and expanding
standard deviations.
}
\description{
A function for computing the rolling and expanding standard deviations of time-series data.
}
\details{
The denominator used gives an unbiased estimate of the standard deviation,
so if the weights are the default then the divisor \code{n - 1} is obtained.
}
\examples{
n <- 15
x <- rnorm(n)
weights <- 0.9 ^ (n:1)

# rolling standard deviations with complete windows
roll_sd(x, width = 5)

# rolling standard deviations with partial windows
roll_sd(x, width = 5, min_obs = 1)

# expanding standard deviations with partial windows
roll_sd(x, width = n, min_obs = 1)

# expanding standard deviations with partial windows and weights
roll_sd(x, width = n, min_obs = 1, weights = weights)
}
