% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_eigen}
\alias{roll_eigen}
\title{Rolling Eigenvalues and Eigenvectors}
\usage{
roll_eigen(data, width, weights = rep(1, width), center = TRUE,
  scale = FALSE, min_obs = width, complete_obs = TRUE,
  na_restore = FALSE, parallel_for = c("rows", "cols"))
}
\arguments{
\item{data}{matrix or xts object. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{weights}{vector. Weights for each observation within a window.}

\item{center}{logical. If \code{TRUE} then the weighted mean of each variable is used,
if \code{FALSE} then zero is used.}

\item{scale}{logical. If \code{TRUE} then the weighted standard deviation of each variable is used,
if \code{FALSE} then no scaling is done.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window, 
otherwise result is NA.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then pairwise is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{parallel_for}{character. Executes a "for" loop in which iterations run in parallel by
\code{rows} or \code{cols}.}
}
\value{
A list containing the following components:
\item{values}{An object of the same class and dimension as \code{x} with the rolling eigenvalues.}
\item{vectors}{A cube with each slice the rolling eigenvectors.}
}
\description{
A parallel function for computing rolling eigenvalues and eigenvectors of time-series data.
}
\note{
If users are already taking advantage of parallelism using multithreaded BLAS/LAPACK
libraries, then limit the number of cores in the RcppParallel package to one with the
\code{\link[RcppParallel]{setThreadOptions}} function.
}
\examples{
n_vars <- 10
n_obs <- 1000
data <- matrix(rnorm(n_obs * n_vars), nrow = n_obs, ncol = n_vars)

# 252-day rolling eigenvalues and eigenvectors
result <- roll_eigen(data, 252)

# Equivalent to 'na.rm = TRUE'
result <- roll_eigen(data, 252, min_obs = 1)

# Expanding window
result <- roll_eigen(data, n_obs, min_obs = 1)

# Exponential decay
weights <- 0.9 ^ (251:0)
result <- roll_eigen(data, 252, weights, min_obs = 1)
}
\seealso{
\code{\link[RcppParallel]{setThreadOptions}} for thread options via RcppParallel.
}

