% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refresh.R
\name{incremental_refresh}
\alias{incremental_refresh}
\alias{incremental_refresh.star_database}
\title{Refresh a star database in a constellation}
\usage{
incremental_refresh(db, sdbu, existing_instances, replace_transformations, ...)

\method{incremental_refresh}{star_database}(
  db,
  sdbu,
  existing_instances = "ignore",
  replace_transformations = FALSE,
  ...
)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{sdbu}{A \code{star_database_update} object.}

\item{existing_instances}{A string, operation to be carried out on the instances
of already existing facts. The possible values are: "ignore", "replace",
"group" and "delete".}

\item{replace_transformations}{A boolean, replace the \code{star_database}
transformation code with the \code{star_database_update} one.}

\item{...}{internal test parameters.}
}
\value{
A \code{star_database} object.
}
\description{
Incremental update of a star database from the star database generated with
the new data.
}
\details{
There may be data in the update that already exists in the facts: it is
indicated what to do with it, replace it, group it, delete it or ignore it in
the update.

If to obtain the update data we have had to perform new transformations (which
were not necessary to obtain the star database), we can indicate that these are
the new transformation operations for the star database. These operations are
not applied to the star database, they will only be applied to new periodic
updates.
}
\examples{

db <-
  flat_table('ft_num', ft_cause_rpd[ft_cause_rpd$City != 'Cambridge' &
                                      ft_cause_rpd$WEEK != '4',]) |>
  as_star_database(mrs_cause_schema_rpd) |>
  role_playing_dimension(rpd = "When",
                         roles = c("When Available", "When Received"))
f2 <- flat_table('ft_num2', ft_cause_rpd[ft_cause_rpd$City != 'Bridgeport' &
                                           ft_cause_rpd$WEEK != '2',])
f2 <- f2 |>
  update_according_to(db)

db <- db |>
  incremental_refresh(f2)

}
\seealso{
\code{\link{star_database}}

Other star database refresh functions: 
\code{\link{get_existing_fact_instances}()},
\code{\link{get_lookup_tables}()},
\code{\link{get_new_dimension_instances}()},
\code{\link{get_star_database}()},
\code{\link{get_star_schema}()},
\code{\link{get_transformation_code}()},
\code{\link{get_transformation_file}()},
\code{\link{update_according_to}()}
}
\concept{star database refresh functions}
