% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{mrs_ft}
\alias{mrs_ft}
\title{Flat table generated from MRS file}
\format{
A \code{flat_table}.
}
\source{
\url{https://catalog.data.gov/dataset/deaths-in-122-u-s-cities-1962-2016-122-cities-mortality-reporting-system}
}
\usage{
mrs_ft
}
\description{
The original dataset covers from 1962 to 2016. For each week, in 122 US cities,
from the original file, we have stored in the package a file with the same
format as the original file but that includes only 1\% of its data, selected at
random.
}
\examples{
# Defined by:
file <-
  system.file(
    "extdata",
    "mrs_122_us_cities_1962_2016.csv",
    package = "rolap"
  )

\donttest{
mrs_ft <-
  read_flat_table_file(name = 'mrs', file, unknown_value = "Not available")
}

}
\seealso{
Other mrs example data: 
\code{\link{ft_age_rpd}},
\code{\link{ft_age}},
\code{\link{ft_cause_rpd}},
\code{\link{ft_num}},
\code{\link{ft}},
\code{\link{mrs_db}},
\code{\link{mrs_ft_new}}
}
\concept{mrs example data}
\keyword{datasets}
