% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constellation.R
\name{constellation}
\alias{constellation}
\title{Create constellation}
\usage{
constellation(name = NULL, ...)
}
\arguments{
\item{name}{A string.}

\item{...}{\code{star_database} objects.}
}
\value{
A \code{star_database} object.
}
\description{
Creates a constellation from a list of \code{star_database} objects. All
dimensions with the same name in the star schemas have to be conformable
(share the same structure, even though they have different instances).
}
\examples{

db1 <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
db2 <- star_database(mrs_age_schema, ft_age) |>
  snake_case()
ct1 <- constellation("MRS", db1, db2)


db3 <- star_database(mrs_cause_schema_rpd, ft_cause_rpd) |>
  role_playing_dimension(
    rpd = "When",
    roles = c("When Available", "When Received")
  )

db4 <- star_database(mrs_age_schema_rpd, ft_age_rpd) |>
  role_playing_dimension(
    rpd = "When Arrived",
    roles = c("When Available")
  )
ct2 <- constellation("MRS", db3, db4)

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}

Other star database and constellation definition functions: 
\code{\link{get_role_playing_dimension_names}()}
}
\concept{star database and constellation definition functions}
