% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_functions.R
\name{download_attachments}
\alias{download_attachments}
\title{Download attachments for table rows}
\usage{
download_attachments(
  rows,
  table_meta,
  save_to_directory,
  skip_if_instance_folder_exists = FALSE
)
}
\arguments{
\item{rows}{A tibble or data frame containing the table rows to download attachments for.}

\item{table_meta}{List. Metadata for the table, as returned by \code{get_table_metadata(table_name)}.}

\item{save_to_directory}{String. The parent directory where attachments will be saved.
A subdirectory with the name of the table will be created, and each row with attachments
will have its own subfolder under this directory.}

\item{skip_if_instance_folder_exists}{Logical. If \code{TRUE}, rows with an existing instance folder
will be skipped to avoid re-downloading attachments. Defaults to \code{FALSE}.}
}
\value{
Invisibly returns \code{NULL}. Downloads the attachments as a side effect.
}
\description{
This function downloads attachments for the specified table rows and saves them
in a structured directory. Each row with attachments will have a dedicated folder
under the table-specific subdirectory.
}
