% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_indices.R
\name{RaoStirling}
\alias{RaoStirling}
\title{Rao-Stirling diversity index based on the counts of cited disciplines.}
\usage{
RaoStirling(count.matrix, similarity)
}
\arguments{
\item{count.matrix}{Vector or matrix that contains the counts of references to different disciplines of a single publication (vector) or of several publications (matrix).
If count.matrix is a vector its length is equal to the total number of disciplines.
In case it is a matrix its dimensions are \emph{n} x \emph{m}, being n the total number of disciplines and m the number of publications for which the lower/upper bound will be computed.}

\item{similarity}{A positive semi-definite matrix that encodes the similarity between disciplines, as explain in Porter and Rafols (2009).
The dimensions of this matrix are \emph{n} x \emph{n}, being \emph{n} the total number of disciplines.
The number of rows and the number columns of this matrix need to be equal to the number of rows of \code{count.matrix}.
The self-similarities (i.e. the diagonal elements) have to be 1.}
}
\value{
The Rao-Stirling diversity index of one or several publications.
}
\description{
This function calculates the Rao-Stirling diversity index of one or several publications, based on the count of citations of the publication(s) to different disciplines.
}
\examples{
#Load data
data(pubdata1)

#Get Rao-Stirling diversity index of all publications in the dataset
RaoStirling(pd1.count.matrix, pd1.similarity)

#Get Rao-Stirling diversity index of one publication of the dataset
RaoStirling(pd1.count.matrix[,2], pd1.similarity)

}
\references{
Porter, A. and Rafols, I. (2009) Is science becoming more interdisciplinary? Measuring and mapping six research fields over time. Scientometrics, Vol. 81, No. 3 (719-745). DOI:10.1007/s11192-008-2197-2
}
