detail=function(x){
res <- list(x=x,
	    isS4=isS4(x),
	    isObject=is.object(x),
	    class=class(x),
	    attributes=attributes(x))
res
}

computeScores = function (x, newdata, scoresMethod) {
    if (!is.list(x))
	stop("x is not a list")

    if (scoresMethod == "none"){
          scoringCoef=F=meanF=corF=NULL
    }
    else if (scoresMethod == "regression"){
        # ӵ÷ϵ
	  scoringCoef=t(x$loadings[]) %*% solve(x$correlation)
        # ӵ÷־
          F=newdata %*% solve(x$correlation) %*% x$loadings[] 
	# ӵ÷־Fֵ
	  meanF=apply(F,2,mean)
	# ӵ÷־Fؾ
          corF=cor(F)
     }
     else{ ## (scoresMethod == "Bartlett")
	# ӵ÷ϵ
  	  ADA.inv=solve(t(x$loadings[]) %*% diag(1/x$uniquenesses) %*% x$loadings[])
  	  scoringCoef=ADA.inv %*% t(x$loadings[]) %*% diag(1/x$uniquenesses)
	# ӵ÷־
  	  F=newdata %*% diag(1/x$uniquenesses) %*% x$loadings[] %*% ADA.inv
	# ӵ÷־Fֵ
	  meanF=apply(F,2,mean)
	# ӵ÷־Fؾ
          corF=cor(F)
     }

     res <- list(
		scoringCoef=scoringCoef,
		F=F,
		meanF=meanF, 
		corF=corF)
     res
}
