% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_robotstxts.R
\name{get_robotstxts}
\alias{get_robotstxts}
\title{function to get multiple robotstxt files}
\usage{
get_robotstxts(
  domain,
  warn = TRUE,
  force = FALSE,
  user_agent = utils::sessionInfo()$R.version$version.string,
  ssl_verifypeer = c(1, 0),
  use_futures = FALSE,
  verbose = FALSE,
  rt_request_handler = robotstxt::rt_request_handler,
  rt_robotstxt_http_getter = robotstxt::get_robotstxt_http_get,
  on_server_error = on_server_error_default,
  on_client_error = on_client_error_default,
  on_not_found = on_not_found_default,
  on_redirect = on_redirect_default,
  on_domain_change = on_domain_change_default,
  on_file_type_mismatch = on_file_type_mismatch_default,
  on_suspect_content = on_suspect_content_default
)
}
\arguments{
\item{domain}{domain from which to download robots.txt file}

\item{warn}{warn about being unable to download domain/robots.txt because of}

\item{force}{if TRUE instead of using possible cached results the function
will re-download the robotstxt file HTTP response status 404. If this
happens,}

\item{user_agent}{HTTP user-agent string to be used to retrieve robots.txt
file from domain}

\item{ssl_verifypeer}{analog to CURL option
\url{https://curl.haxx.se/libcurl/c/CURLOPT_SSL_VERIFYPEER.html}
-- and might help with robots.txt file retrieval in some cases}

\item{use_futures}{Should future::future_lapply be used for possible
parallel/async retrieval or not. Note: check out help
pages and vignettes of package future on how to set up
plans for future execution because the robotstxt package
does not do it on its own.}

\item{verbose}{make function print out more information}

\item{rt_request_handler}{handler function that handles request according to
the event handlers specified}

\item{rt_robotstxt_http_getter}{function that executes HTTP request}

\item{on_server_error}{request state handler for any 5xx status}

\item{on_client_error}{request state handler for any 4xx HTTP status that is
not 404}

\item{on_not_found}{request state handler for HTTP status 404}

\item{on_redirect}{request state handler for any 3xx HTTP status}

\item{on_domain_change}{request state handler for any 3xx HTTP status where
domain did change as well}

\item{on_file_type_mismatch}{request state handler for content type other
than 'text/plain'}

\item{on_suspect_content}{request state handler for content that seems to be
something else than a robots.txt file (usually a JSON, XML or HTML)}
}
\description{
function to get multiple robotstxt files
}
