% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify.R
\name{fortify.test_mediation}
\alias{fortify.test_mediation}
\alias{fortify.boot_test_mediation}
\alias{fortify.sobel_test_mediation}
\alias{fortify.list}
\title{Convert (robust) mediation analysis results into a data frame for plotting}
\usage{
\method{fortify}{boot_test_mediation}(model, data, method = c("dot",
  "density"), parm = NULL, ...)

\method{fortify}{sobel_test_mediation}(model, data, method = c("dot",
  "density"), parm = NULL, level = 0.95, ...)

\method{fortify}{list}(model, data, ...)
}
\arguments{
\item{model}{an object inheriting from class \code{"\link{test_mediation}"}
containing results from (robust) mediation analysis.}

\item{data}{for the \code{"boot_test_mediation"} method, this is currently
ignored.  For the \code{"sobel_test_mediation"} method, this is an optional
numeric vector containing the \eqn{x}-values at which to evaluate the
assumed normal density from Sobel's test (only used in case of a density
plot).  The default is to take 100 equally spaced points between the
estimated indirect effect \eqn{\pm}{+/-} three times the standard error
according to Sobel's formula.}

\item{method}{a character string specifying for which plot to construct the
data frame.  Possible values are \code{"dot"} for a dot plot of selected
coefficients, or \code{"density"} for a density plot of the indirect
effect(s).}

\item{parm}{a character string specifying the coefficients to be included
in a dot plot.  The default is to include the direct and the indirect
effect(s).}

\item{\dots}{additional arguments are currently ignored.}

\item{level}{numeric;  the confidence level of the confidence intervals
from Sobel's test to be included in a dot plot.  The default is to include
95\% confidence intervals.}
}
\value{
A data frame containing the necessary data for the selected plot, as
well as additional information stored in attributes.
}
\description{
Supplement the estimated coefficients with other useful information for
informative visualization of the (robust) mediation analysis results.  It is
thereby possible to construct data frames for dot plots of selected
coefficients, as well as density plots of the indirect effect.
}
\examples{
data("BSG2014")

# run fast and robust bootstrap test
test <- test_mediation(BSG2014,
                       x = "ValueDiversity",
                       y = "TeamCommitment",
                       m = "TaskConflict")

# data for dot plot
dot <- fortify(test, method = "dot")
plot_mediation(dot)

# data for density plot
density <- fortify(test, method = "density")
plot_mediation(density)

}
\seealso{
\code{\link{test_mediation}}, \code{\link{plot_mediation}}
}
\author{
Andreas Alfons
}
\keyword{utilities}
