% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_spearman_inference.R
\name{BCIntervalSpearman}
\alias{BCIntervalSpearman}
\title{Bootstrap Confidence Interval on Spearman's Correlation Coefficient between Univariate Functional Datasets}
\usage{
BCIntervalSpearman(
  fD1,
  fD2,
  ordering = "MEI",
  bootstrap_iterations = 1000,
  alpha = 0.05,
  verbose = FALSE
)
}
\arguments{
\item{fD1}{is the first univariate functional sample in form of an \code{fData} object.}

\item{fD2}{is the first univariate functional sample in form of an \code{fData} object.}

\item{ordering}{is either \code{MEI} (default) or \code{MHI}, and indicates the ordering relation
to be used during in the Spearman's coefficient computation.}

\item{bootstrap_iterations}{is the number of bootstrap iterations to use in order to estimate the
confidence interval (default is 1000).}

\item{alpha}{controls the coverage probability (1-\code{alpha}).}

\item{verbose}{whether to log information on the progression of bootstrap iterations.}
}
\value{
The function returns a list of two elements, \code{lower} and \code{upper}, representing
the lower and upper end of the bootstrap confidence interval.
}
\description{
This function computes the bootstrap confidence interval of coverage probability
\eqn{1 - \alpha} for the Spearman correlation coefficient between two univariate functional samples.
}
\details{
The function takes two samples of compatible functional data (i.e., they must be defined over the
same grid and have same number of observations) and computes a bootstrap confidence interval for
their Spearman correlation coefficient.
}
\examples{
set.seed(1)

N <- 200
P <- 100

grid <- seq(0, 1, length.out = P)

# Creating an exponential covariance function to simulate Gaussian data
Cov <- exp_cov_function(grid, alpha = 0.3, beta = 0.4)

# Simulating (independent) Gaussian functional data with given center and covariance function
Data_1 <- generate_gauss_fdata( N, centerline = sin( 2 * pi * grid ), Cov = Cov )
Data_2 <- generate_gauss_fdata(
  N = N,
  centerline = sin(2 * pi * grid),
  Cov = Cov
)

# Using the simulated data as (independent) components of a bivariate functional dataset
mfD <- mfData(grid, list(Data_1, Data_2))

\donttest{
BCIntervalSpearman(mfD$fDList[[1]], mfD$fDList[[2]], ordering = "MEI")
BCIntervalSpearman(mfD$fDList[[1]], mfD$fDList[[2]], ordering = "MHI")
}

# BC intervals contain zero since the functional samples are uncorrelated.

}
\seealso{
\code{\link{cor_spearman}}, \code{\link{cor_spearman_accuracy}}, \code{\link{fData}},
\code{\link{mfData}}, \code{\link{BCIntervalSpearmanMultivariate}}
}
