% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fData.R
\name{append_mfData}
\alias{append_mfData}
\title{Append two compatible multivariate functional datasets}
\usage{
append_mfData(mfD1, mfD2)
}
\arguments{
\item{mfD1}{is the first multivariate functional dataset, stored into an \code{mfData} object.}

\item{mfD2}{is the second multivariate functional dataset, stored into an \code{mfData} object.}
}
\value{
The function returns a \code{mfData} object containing the union of \code{mfD1} and \code{mfD2}
}
\description{
This is a convenience function that simplifies the task of appending multivariate
functional observations of two datasets to a unique multivariate functional dataset.
}
\details{
The two original datasets must be compatible, i.e. must have same number of components
(dimensions) and must be defined on the same grid. If we denote with
\eqn{X_1^(i), \ldots, X_n^(i)}, \eqn{i=0, \ldots, L} the first dataset, defined over the
grid \eqn{I = t_1, \ldots, t_P}, and with \eqn{Y_1^(i), \ldots, Y_m^(i)}, \eqn{i=0, \ldots, L}
the second functional dataset, the method returns the union dataset obtained by taking all the
\eqn{n + m} observations together.
}
\examples{
# Creating two simple bivariate datasets

grid = seq(0, 2 * pi, length.out = 100)

values11 = matrix( c(sin(grid),
                     sin(2 * grid)), nrow = 2, ncol = length(grid),
                   byrow=TRUE)
values12 = matrix( c(sin(3 * grid),
                     sin(4 * grid)), nrow = 2, ncol = length(grid),
                   byrow=TRUE)
values21 = matrix( c(cos(grid),
                     cos(2 * grid)), nrow = 2, ncol = length(grid),
                   byrow=TRUE)
values22 = matrix( c(cos(3 * grid),
                     cos(4 * grid)), nrow = 2, ncol = length(grid),
                   byrow=TRUE)

mfD1 = mfData( grid, list(values11, values12) )
mfD2 = mfData( grid, list(values21, values22) )

# Appending them to a unique dataset
append_mfData(mfD1, mfD2)

}
\seealso{
\code{\link{append_fData}}, \code{\link{mfData}}
}
