% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonal_averages.R
\name{seasonal_averages}
\alias{seasonal_averages}
\title{Calculate seasonal averages}
\usage{
seasonal_averages(timeseries, season = "Spring", startseason = NULL,
  endseason = NULL, parallel = FALSE)
}
\arguments{
\item{timeseries}{Time series (xts class).}

\item{season}{Name of the season (Autumn, Winter, Spring, Summer)}

\item{startseason}{String encoding the start of the season (e.g. for spring
in the northen hemisphere this is "03-21")}

\item{endseason}{String encoding the end of the season (e.g. for spring in
the northen emisphere this is "06-20")}

\item{parallel}{Logical, FALSE by default. If parallel = TRUE means that the
function can be used in parallel computations.}
}
\value{
A vector containing the seasonal average and significance level
(p-value) for each time series.
}
\description{
This calculates the seasonal averages from a time series.
}
\examples{
\dontrun{
  seasonal_averages(timeseries = cmr(18019), season = "Spring")
  seasonal_averages(list(cmr(18019), cmr(18019)), season = "Spring")
}

}
