% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ghcnd.R
\name{meteo_pull_monitors}
\alias{meteo_pull_monitors}
\title{Pull GHCND weather data for multiple weather monitors}
\usage{
meteo_pull_monitors(
  monitors,
  keep_flags = FALSE,
  date_min = NULL,
  date_max = NULL,
  var = "all"
)
}
\arguments{
\item{monitors}{A character vector listing the station IDs for all
weather stations the user would like to pull. To get a full and
current list of stations, the user can use the \code{\link[=ghcnd_stations]{ghcnd_stations()}}
function. To identify stations within a certain radius of a location, the
user can use the \code{\link[=meteo_nearby_stations]{meteo_nearby_stations()}} function.}

\item{keep_flags}{TRUE / FALSE for whether the user would like to keep all
the flags for each weather variable. The default is to not keep the
flags (FALSE). See the note below for more information on these flags.}

\item{date_min}{A character string giving the earliest
date of the daily weather time series that the user would
like in the final output. This character string should be formatted as
"yyyy-mm-dd". If not specified, the default is to keep all daily data for
the queried weather site from the earliest available date.}

\item{date_max}{A character string giving the latest
date of the daily weather time series that the user would
like in the final output. This character string should be formatted as
"yyyy-mm-dd". If not specified, the default is to keep all daily data for
the queried weather site through the most current available date.}

\item{var}{A character vector specifying either \code{"all"} (pull all
available weather parameters for the site) or the weather parameters to
keep in the final data (e.g., \code{c("TMAX", "TMIN")} to only keep
maximum and minimum temperature). Example choices for this argument
include:
\itemize{
\item \code{PRCP}: Precipitation, in tenths of millimeters
\item \code{TAVG}: Average temperature, in tenths of degrees Celsius
\item \code{TMAX}: Maximum temperature, in tenths of degrees Celsius
\item \code{TMIN}: Minimum temperature, in tenths of degrees Celsius
}

A full list of possible weather variables is available in NOAA's README
file for the GHCND data
.
Most weather stations will only have a small subset of all the possible
weather variables, so the data generated by this function may not include
all of the variables the user specifies through this argument.}
}
\value{
A data frame of daily weather data for multiple weather monitors,
converted to a tidy format. All weather variables may not exist for all
weather stations. Examples of variables returned are:
\itemize{
\item \code{id}: Character string with the weather station site id
\item \code{date}: Date of the observation
\item \code{prcp}: Precipitation, in tenths of mm
\item \code{tavg}: Average temperature, in tenths of degrees Celsius
\item \code{tmax}: Maximum temperature, in tenths of degrees Celsius
\item \code{tmin}: Minimum temperature, in tenths of degrees Celsius
\item \code{awnd}: Average daily wind speed, in meters / second
\item \code{wsfg}: Peak gust wind speed, in meters / second
}

There are other possible weather variables in the Global Historical
Climatology Network; see
for a full
list. If the \code{var} argument is something other than "all", then
only variables included in that argument will be included in the output
data frame. All variables are in the units specified in the linked file
(note that, in many cases, measurements are given in tenths of the units
more often used, e.g., tenths of degrees for temperature). All column names
correspond to variable names in the linked file, but with  all uppercase
letters changed to lowercase.
}
\description{
This function takes a vector of one or more weather station IDs. It will pull
the weather data from the Global Historical Climatology Network's daily
data (GHCND) for each of the stations and join them together in a single tidy
dataframe. For any weather stations that the user calls that are not
available by ftp from GHCND, the function will return a warning
giving the station ID.
}
\note{
The weather flags, which are kept by specifying
\code{keep_flags = TRUE} are:
\itemize{
\item \verb{*_mflag}: Measurement flag, which gives some information on how
the observation was measured.
\item \verb{*_qflag}: Quality flag, which gives quality information on the
measurement, like if it failed to pass certain quality checks.
\item \verb{*_sflag}: Source flag. This gives some information on the
weather collection system (e.g., U.S. Cooperative Summary of the Day,
Australian Bureau of Meteorology) the weather observation comes from.
}

More information on the interpretation of these flags can be found in the
README file for the NCDC's Daily Global Historical Climatology Network's
data at

This function converts any value of -9999 to a missing value for the
variables "prcp", "tmax", "tmin", "tavg", "snow", and "snwd". However,
for some weather observations, there still may be missing values coded
using a series of "9"s of some length. You will want to check your final
data to see if there are lurking missing values given with series of "9"s.

This function may take a while to run.
}
\examples{
\dontrun{

monitors <- c("ASN00003003", "ASM00094299", "ASM00094995", "ASM00094998")
all_monitors_clean <- meteo_pull_monitors(monitors)

}

}
\references{
For more information about the data pulled with this function, see:

Menne, M.J., I. Durre, R.S. Vose, B.E. Gleason, and T.G. Houston, 2012:
An overview of the Global Historical Climatology Network-Daily Database.
Journal of Atmospheric and Oceanic Technology, 29, 897-910,
doi:10.1175/JTECH-D-11-00103.1.
}
\author{
Brooke Anderson \email{brooke.anderson@colostate.edu}
}
