% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seaice.r
\name{seaiceeurls}
\alias{seaiceeurls}
\title{Make all urls for sea ice data}
\usage{
seaiceeurls(yr = NULL, mo = NULL, pole = NULL, format = "shp")
}
\arguments{
\item{yr}{(numeric) a year}

\item{mo}{(character) a month, as character abbrevation of a month}

\item{pole}{(character) one of S (south) or N (north)}
}
\value{
A vector of urls (character)
}
\description{
Make all urls for sea ice data
}
\examples{
\dontrun{
# Get all urls
seaiceeurls()

# for some range of years
seaiceeurls(yr = 1980:1983)
seaiceeurls(yr = 1980, mo = c("Jan", "Feb", "Mar"))
seaiceeurls(yr = 1980:1983, mo = c("Jan", "Apr", "Oct"))

# Get urls for Feb of all years, both S and N poles
seaiceeurls(mo='Feb')

# Get urls for Feb of all years, just S pole
seaiceeurls(mo='Feb', pole='S')

# Get urls for Feb of 1980, just S pole
seaiceeurls(yr=1980, mo='Feb', pole='S')

# GeoTIFF
seaiceeurls(yr=1980, mo='Feb', pole='S', format = "geotiff")
}
}
\keyword{internal}
