# from https://www1.ncdc.noaa.gov/pub/data/cdo/documentation/NORMAL_MLY_documentation.pdf
ncdc_units_normal_mly <- list(
  "MLY-CLDD-BASE45" = list(name = "MLY-CLDD-BASE45", units = "", description = "Long-term averages of monthly cooling degree days with base 45F"),
  "MLY-CLDD-BASE50" = list(name = "MLY-CLDD-BASE50", units = "", description = "Long-term averages of monthly cooling degree days with base 50F"),
  "MLY-CLDD-BASE55" = list(name = "MLY-CLDD-BASE55", units = "", description = "Long-term averages of monthly cooling degree days with base 55F"),
  "MLY-CLDD-BASE57" = list(name = "MLY-CLDD-BASE57", units = "", description = "Long-term averages of monthly cooling degree days with base 57F"),
  "MLY-CLDD-BASE60" = list(name = "MLY-CLDD-BASE60", units = "", description = "Long-term averages of monthly cooling degree days with base 60F"),
  "MLY-CLDD-BASE70" = list(name = "MLY-CLDD-BASE70", units = "", description = "Long-term averages of monthly cooling degree days with base 70F"),
  "MLY-CLDD-BASE72" = list(name = "MLY-CLDD-BASE72", units = "", description = "Long-term averages of monthly cooling degree days with base 72F"),
  "MLY-CLDD-NORMAL" = list(name = "MLY-CLDD-NORMAL", units = "", description = "Long-term averages of monthly cooling degree days with base 65F"),
  "MLY-DUTR-NORMAL" = list(name = "MLY-DUTR-NORMAL", units = "", description = "Long-term averages of monthly diurnal temperature range"),
  "MLY-DUTR-STDDEV" = list(name = "MLY-DUTR-STDDEV", units = "", description = "Long-term standard deviations of monthly diurnal temperature range"),
  "MLY-GRDD-BASE40" = list(name = "MLY-GRDD-BASE40", units = "", description = "Long-term averages of monthly growing degree days with base 40F"),
  "MLY-GRDD-BASE45" = list(name = "MLY-GRDD-BASE45", units = "", description = "Long-term averages of monthly growing degree days with base 45F"),
  "MLY-GRDD-BASE50" = list(name = "MLY-GRDD-BASE50", units = "", description = "Long-term averages of monthly growing degree days with base 50F"),
  "MLY-GRDD-BASE55" = list(name = "MLY-GRDD-BASE55", units = "", description = "Long-term averages of monthly growing degree days with base 55F"),
  "MLY-GRDD-BASE57" = list(name = "MLY-GRDD-BASE57", units = "", description = "Long-term averages of monthly growing degree days with base 57F"),
  "MLY-GRDD-BASE60" = list(name = "MLY-GRDD-BASE60", units = "", description = "Long-term averages of monthly growing degree days with base 60F"),
  "MLY-GRDD-BASE65" = list(name = "MLY-GRDD-BASE65", units = "", description = "Long-term averages of monthly growing degree days with base 65F"),
  "MLY-GRDD-BASE70" = list(name = "MLY-GRDD-BASE70", units = "", description = "Long-term averages of monthly growing degree days with base 70F"),
  "MLY-GRDD-BASE72" = list(name = "MLY-GRDD-BASE72", units = "", description = "Long-term averages of monthly growing degree days with base 72F"),
  "MLY-GRDD-TB4886" = list(name = "MLY-GRDD-TB4886", units = "", description = "Long-term averages of monthly growing degree days with truncated bases 48F and 86F"),
  "MLY-GRDD-TB5086" = list(name = "MLY-GRDD-TB5086", units = "", description = "Long-term averages of monthly growing degree days with truncated bases 50F and 86F"),
  "MLY-HTDD-BASE40" = list(name = "MLY-HTDD-BASE40", units = "", description = "Long-term averages of monthly heating degree days with base 40F"),
  "MLY-HTDD-BASE45" = list(name = "MLY-HTDD-BASE45", units = "", description = "Long-term averages of monthly heating degree days with base 45F"),
  "MLY-HTDD-BASE50" = list(name = "MLY-HTDD-BASE50", units = "", description = "Long-term averages of monthly heating degree days with base 50F"),
  "MLY-HTDD-BASE55" = list(name = "MLY-HTDD-BASE55", units = "", description = "Long-term averages of monthly heating degree days with base 55F"),
  "MLY-HTDD-BASE57" = list(name = "MLY-HTDD-BASE57", units = "", description = "Long-term averages of monthly heating degree days with base 57F"),
  "MLY-HTDD-BASE60" = list(name = "MLY-HTDD-BASE60", units = "", description = "Long-term averages of monthly heating degree days with base 60F"),
  "MLY-HTDD-NORMAL" = list(name = "MLY-HTDD-NORMAL", units = "", description = "Long-term averages of monthly heating degree days with base 65F"),
  "MLY-PRCP-25PCTL" = list(name = "MLY-PRCP-25PCTL", units = "", description = "25th percentiles of monthly precipitation totals"),
  "MLY-PRCP-50PCTL" = list(name = "MLY-PRCP-50PCTL", units = "", description = "50th percentiles of monthly precipitation totals"),
  "MLY-PRCP-75PCTL" = list(name = "MLY-PRCP-75PCTL", units = "", description = "75th percentiles of monthly precipitation totals"),
  "MLY-PRCP-AVGNDS-GE001HI" = list(name = "MLY-PRCP-AVGNDS-GE001HI", units = "", description = "Long-term averages of number of days per month with precipitation >= 0.01 inches"),
  "MLY-PRCP-AVGNDS-GE010HI" = list(name = "MLY-PRCP-AVGNDS-GE010HI", units = "", description = "Long-term averages of number of days per month with precipitation >= 0.10 inches"),
  "MLY-PRCP-AVGNDS-GE050HI" = list(name = "MLY-PRCP-AVGNDS-GE050HI", units = "", description = "Long-term averages of number of days per month with precipitation >= 0.50 inches"),
  "MLY-PRCP-AVGNDS-GE100HI" = list(name = "MLY-PRCP-AVGNDS-GE100HI", units = "", description = "Long-term averages of number of days per month with precipitation >= 1.00 inches"),
  "MLY-PRCP-NORMAL" = list(name = "MLY-PRCP-NORMAL", units = "", description = "Long-term averages of monthly precipitation totals"),
  "MLY-SNOW-25PCTL" = list(name = "MLY-SNOW-25PCTL", units = "", description = "25th percentiles of monthly snowfall totals"),
  "MLY-SNOW-50PCTL" = list(name = "MLY-SNOW-50PCTL", units = "", description = "50th percentiles of monthly snowfall totals"),
  "MLY-SNOW-75PCTL" = list(name = "MLY-SNOW-75PCTL", units = "", description = "75th percentiles of monthly snowfall totals"),
  "MLY-SNOW-AVGNDS-GE001TI" = list(name = "MLY-SNOW-AVGNDS-GE001TI", units = "", description = "Long-term averages of number of days per month with Snowfall >= 0.1 inches"),
  "MLY-SNOW-AVGNDS-GE010TI" = list(name = "MLY-SNOW-AVGNDS-GE010TI", units = "", description = "Long-term averages of number of days per month with Snowfall >= 1.0 inches"),
  "MLY-SNOW-AVGNDS-GE030TI" = list(name = "MLY-SNOW-AVGNDS-GE030TI", units = "", description = "Long-term averages of number of days per month with Snowfall >= 3.0 inches"),
  "MLY-SNOW-AVGNDS-GE050TI" = list(name = "MLY-SNOW-AVGNDS-GE050TI", units = "", description = "Long-term averages of number of days per month with Snowfall >= 5.0 inches"),
  "MLY-SNOW-AVGNDS-GE100TI" = list(name = "MLY-SNOW-AVGNDS-GE100TI", units = "", description = "Long-term averages of number of days per month with Snowfall >= 10.0 inches"),
  "MLY-SNOW-NORMAL" = list(name = "MLY-SNOW-NORMAL", units = "", description = "Long-term averages of monthly snowfall totals"),
  "MLY-SNWD-AVGNDS-GE001WI" = list(name = "MLY-SNWD-AVGNDS-GE001WI", units = "", description = "Long-term averages of number of days per month with snow depth >= 1 inch"),
  "MLY-SNWD-AVGNDS-GE003WI" = list(name = "MLY-SNWD-AVGNDS-GE003WI", units = "", description = "Long-term averages of number of days per month with snow depth >= 3 inches"),
  "MLY-SNWD-AVGNDS-GE005WI" = list(name = "MLY-SNWD-AVGNDS-GE005WI", units = "", description = "Long-term averages of number of days per month with snow depth >= 5 inches"),
  "MLY-SNWD-AVGNDS-GE010WI" = list(name = "MLY-SNWD-AVGNDS-GE010WI", units = "", description = "Long-term averages of number of days per month with snow depth >= 10 inches"),
  "MLY-TAVG-NORMAL" = list(name = "MLY-TAVG-NORMAL", units = "", description = "Long-term averages of monthly average temperature"),
  "MLY-TAVG-STDDEV" = list(name = "MLY-TAVG-STDDEV", units = "", description = "Long-term standard deviations of monthly average temperature"),
  "MLY-TMAX-AVGNDS-GRTH040" = list(name = "MLY-TMAX-AVGNDS-GRTH040", units = "", description = "Long-term average number of days per month where tmax is greater than or equal to 40F"),
  "MLY-TMAX-AVGNDS-GRTH050" = list(name = "MLY-TMAX-AVGNDS-GRTH050", units = "", description = "Long-term average number of days per month where tmax is greater than or equal to 50F"),
  "MLY-TMAX-AVGNDS-GRTH060" = list(name = "MLY-TMAX-AVGNDS-GRTH060", units = "", description = "Long-term average number of days per month where tmax is greater than or equal to 60F"),
  "MLY-TMAX-AVGNDS-GRTH070" = list(name = "MLY-TMAX-AVGNDS-GRTH070", units = "", description = "Long-term average number of days per month where tmax is greater than or equal to 70F"),
  "MLY-TMAX-AVGNDS-GRTH080" = list(name = "MLY-TMAX-AVGNDS-GRTH080", units = "", description = "Long-term average number of days per month where tmax is greater than or equal to 80F"),
  "MLY-TMAX-AVGNDS-GRTH090" = list(name = "MLY-TMAX-AVGNDS-GRTH090", units = "", description = "Long-term average number of days per month where tmax is greater than or equal to 90F"),
  "MLY-TMAX-AVGNDS-GRTH100" = list(name = "MLY-TMAX-AVGNDS-GRTH100", units = "", description = "Long-term average number of days per month where tmax is greater than or equal to 100F"),
  "MLY-TMAX-AVGNDS-LSTH032" = list(name = "MLY-TMAX-AVGNDS-LSTH032", units = "", description = "Long-term average number of days per month where tmax is less than or equal to 32F"),
  "MLY-TMAX-NORMAL" = list(name = "MLY-TMAX-NORMAL", units = "", description = "Long-term averages of monthly maximum temperature"),
  "MLY-TMAX-STDDEV" = list(name = "MLY-TMAX-STDDEV", units = "", description = "Long-term standard deviations of monthly maximum temperature"),
  "MLY-TMIN-AVGNDS-LSTH000" = list(name = "MLY-TMIN-AVGNDS-LSTH000", units = "", description = "Long-term average number of days per month where tmin is less than or equal to 0F"),
  "MLY-TMIN-AVGNDS-LSTH010" = list(name = "MLY-TMIN-AVGNDS-LSTH010", units = "", description = "Long-term average number of days per month where tmin is less than or equal to 10F"),
  "MLY-TMIN-AVGNDS-LSTH020" = list(name = "MLY-TMIN-AVGNDS-LSTH020", units = "", description = "Long-term average number of days per month where tmin is less than or equal to 20F"),
  "MLY-TMIN-AVGNDS-LSTH032" = list(name = "MLY-TMIN-AVGNDS-LSTH032", units = "", description = "Long-term average number of days per month where tmin is less than or equal to 32F"),
  "MLY-TMIN-AVGNDS-LSTH040" = list(name = "MLY-TMIN-AVGNDS-LSTH040", units = "", description = "Long-term average number of days per month where tmin is less than or equal to 40F"),
  "MLY-TMIN-AVGNDS-LSTH050" = list(name = "MLY-TMIN-AVGNDS-LSTH050", units = "", description = "Long-term average number of days per month where tmin is less than or equal to 50F"),
  "MLY-TMIN-AVGNDS-LSTH060" = list(name = "MLY-TMIN-AVGNDS-LSTH060", units = "", description = "Long-term average number of days per month where tmin is less than or equal to 60F"),
  "MLY-TMIN-AVGNDS-LSTH070" = list(name = "MLY-TMIN-AVGNDS-LSTH070", units = "", description = "Long-term average number of days per month where tmin is less than or equal to 70F"),
  "MLY-TMIN-NORMAL" = list(name = "MLY-TMIN-NORMAL", units = "", description = "Long-term averages of monthly minimum temperature"),
  "MLY-TMIN-PRBOCC-LSTH016" = list(name = "MLY-TMIN-PRBOCC-LSTH016", units = "", description = "probability of 16F or below at least once in the month"),
  "MLY-TMIN-PRBOCC-LSTH020" = list(name = "MLY-TMIN-PRBOCC-LSTH020", units = "", description = "probability of 20F or below at least once in the month"),
  "MLY-TMIN-PRBOCC-LSTH024" = list(name = "MLY-TMIN-PRBOCC-LSTH024", units = "", description = "probability of 24F or below at least once in the month"),
  "MLY-TMIN-PRBOCC-LSTH028" = list(name = "MLY-TMIN-PRBOCC-LSTH028", units = "", description = "probability of 28F or below at least once in the month"),
  "MLY-TMIN-PRBOCC-LSTH032" = list(name = "MLY-TMIN-PRBOCC-LSTH032", units = "", description = "probability of 32F or below at least once in the month"),
  "MLY-TMIN-PRBOCC-LSTH036" = list(name = "MLY-TMIN-PRBOCC-LSTH036", units = "", description = "probability of 36F or below at least once in the month"),
  "MLY-TMIN-STDDEV" = list(name = "MLY-TMIN-STDDEV", units = "", description = "Long-term standard deviations of monthly minimum temperature")
)
