% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness.index.user_function.R
\name{robustness_index_user}
\alias{robustness_index_user}
\title{Robustness index when 'metafor' or 'netmeta' are used}
\usage{
robustness_index_user(sens, pkg, attribute, threshold)
}
\arguments{
\item{sens}{A list of R objects of class
\code{\link[netmeta:netmeta]{netmeta}},
\code{\link[netmeta:netmetabin]{netmetabin}} (see
\href{https://CRAN.R-project.org/package=netmeta}{netmeta}) or
\code{\link[metafor:rma]{rma}}, \code{\link[metafor:rma.glmm]{rma.glmm}},
\code{\link[metafor:rma.mh]{rma.mh}}, \code{\link[metafor:rma.mv]{rma.mv}},
\code{\link[metafor:rma.peto]{rma.peto}}, and
\code{\link[metafor:rma.uni]{rma.uni}}
(see \href{https://CRAN.R-project.org/package=metafor}{metafor}).
The number of elements equals the number of analyses using the same dataset
and the same R-package. The first element should refer to the primary
analysis. Hence, the list should include at least two elements
(see 'Details').}

\item{pkg}{Character string indicating the R-package with values
\code{"netmeta"}, or \code{"metafor"}.}

\item{attribute}{This is relevant only for (see
\href{https://CRAN.R-project.org/package=netmeta}{netmeta}). A vector of
at least two characters with values \code{"TE.common"} or
\code{"TE.random"}. See 'Values' in \code{\link[netmeta:netmeta]{netmeta}}
or \code{\link[netmeta:netmetabin]{netmetabin}}.}

\item{threshold}{A number indicating the threshold of robustness, that is,
the minimally allowed deviation between the primary analysis (the first
element in \code{sens}) and re-analysis results. See 'Details' below.}
}
\value{
\code{robustness_index_user} prints on the R console a message in
  green text on the threshold of robustness determined by the user.
  Then, the function returns the following list of elements:
  \item{robust_index}{A numeric scalar or vector on the robustness
  index values. In the case of a pairwise meta-analysis,
  \code{robust_index} is scalar as only one summary effect size is obtained.
  In the case of network meta-analysis, \code{robust_index} is a vector with
  length equal to the number of possible pairwise comparisons;
  one robustness index per possible comparison.}
  \item{robust}{A character or character vector (of same length with
  \code{robust_index}) on whether the primary analysis results are
  \emph{robust} or \emph{frail} to the different re-analyses.}
  \item{kld}{A vector or matrix on the Kullback-Leibler divergence
  (KLD) measure in the summary effect size from a subsequent re-analysis to
  the primary analysis. In the case of a pairwise meta-analysis, \code{kld}
  is a vector with length equal to the number of total analyses (one KLD
  value is obtained per analysis). The number of total analyses equals the
  length of  \code{sens}.
  In the case of network meta-analysis, \code{robust_index} is a matrix with
  number of rows equal to the number of total analyses and number of columns
  equal to the number of  possible pairwise comparisons; one KLD
  value per analysis and possible comparison.}
  \item{attribute}{The attributes considered.}
  \item{threshold}{The threshold used to be inherited by the
  \code{\link{heatmap_robustness}} function. See 'Details'.}
}
\description{
Calculates the robustness index for a sensitivity analysis
  (Spineli et al., 2021) performed using the R-package
  \href{https://CRAN.R-project.org/package=netmeta}{netmeta} or
  \href{https://CRAN.R-project.org/package=metafor}{metafor}.
  The user defines the input and the function returns the robustness index.
}
\details{
Thresholds of robustness have been proposed only for the odds ratio
  and standardised mean difference (Spineli et al., 2021).
  The user may consider the values 0.28 and 0.17 in the argument
  \code{threshold} for the odds ratio and standardised mean difference effect
  measures (the default values), respectively, or consider other plausible
  values. When the argument \code{threshold} has not been defined,
  \code{robustness_index} considers the default values 0.28 and 0.17 as
  threshold for robustness for binary and continuous outcome, respectively,
  regardless of the effect measure (the default thresholds may not be proper
  choices for other effect measures; hence, use these threshold with great
  caution in this case). Spineli et al. (2021) offers a discussion on
  specifying the \code{threshold} of robustness.

  When other effect measure is used (other than odds ratio or standardised
  mean difference) or the elements in \code{sens} refer to different effect
  measures, the execution of the function will be stopped and an error
  message will be printed in the R console.

  In \code{robust}, the value \code{"robust"} appears when the calculated
  \code{robust_index} is less than \code{threshold}; otherwise, the value
  \code{"frail"} appears.
}
\examples{
library(netmeta)

# Load data from 'netmeta'
data(Baker2009)

\donttest{
# Transform from arm-based to contrast-based format
p1 <- pairwise(treatment, exac, total, studlab = paste(study, year),
data = Baker2009, sm = "OR")

# Conduct standard network meta-analysis
net1 <- netmeta(p1, ref = "Placebo")

# Calculate the robustness index (random-effects versus fixed-effect)
robustness_index_user(sens = list(net1, net1),
                      pkg = "netmeta",
                      attribute = c("TE.random", "TE.common"),
                      threshold = 0.28)
}

}
\references{
Kullback S, Leibler RA. On information and sufficiency.
\emph{Ann Math Stat} 1951;\bold{22}(1):79--86. doi: 10.1214/aoms/1177729694

Spineli LM, Kalyvas C, Papadimitropoulou K. Quantifying the robustness of
primary analysis results: A case study on missing outcome data in pairwise
and network meta-analysis.
\emph{Res Synth Methods} 2021;\bold{12}(4):475--90. doi: 10.1002/jrsm.1478
}
\seealso{
\code{\link[metafor:rma]{rma}},
  \code{\link[metafor:rma.glmm]{rma.glmm}},
  \code{\link[metafor:rma.mh]{rma.mh}}, \code{\link[metafor:rma.mv]{rma.mv}},
  \code{\link[metafor:rma.peto]{rma.peto}},
  \code{\link[metafor:rma.uni]{rma.uni}},
  \code{\link[netmeta:netmeta]{netmeta}},
  \code{\link[netmeta:netmetabin]{netmetabin}},
  \code{\link{heatmap_robustness}}
}
\author{
{Loukia M. Spineli}
}
