% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.network_function.R
\name{describe_network}
\alias{describe_network}
\title{A function to describe the evidence base}
\usage{
describe_network(data, drug_names, measure)
}
\arguments{
\item{data}{A data-frame of a one-trial-per-row format containing arm-level
data of each trial. See 'Format' in \code{\link{run_model}}.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data}. If \code{drug_names} is
not defined, the order of the interventions as they appear in \code{data}
is used, instead.}

\item{measure}{Character string indicating the effect measure with values
\code{"OR"}, \code{"MD"}, \code{"SMD"}, or \code{"ROM"} for the odds ratio,
mean difference, standardised mean difference and ratio of means,
respectively.}
}
\value{
A list of scalar results and two data-frames to be passed to
  \code{\link{netplot}}. The scalar results include:
  \tabular{ll}{
   \code{direct_comp} \tab The number of observed comparisons in the
   network. \cr
   \tab \cr
   \code{two_arm_ns} \tab The number of two-arm trials in the network. \cr
   \tab \cr
   \code{multi_arm_ns} \tab The number of multi-arm trials in the
   network. \cr
   \tab \cr
   \code{total_rand_network} \tab The total number of randomised participants
    in the network. \cr
   \tab \cr
   \code{prop_obs_network} \tab The proportion of participants who completed
    the trial. \cr
   \tab \cr
   \code{prop_event_network} \tab The proportion of observed events in the
   network. When the outcome is continuous, this element is omitted. \cr
   \tab \cr
   \code{trial_zero_event} \tab The number of trials with at least one arm
   with zero events. When the outcome is continuous, this element is
   omitted. \cr
   \tab \cr
   \code{trial_all_zero_event} \tab The number of trials with zero events in
   all arms. When the outcome is continuous, this element is omitted. \cr
  }

  The two data-frames include\code{table_interventions} and
  \code{table_comparisons}. See 'Value' in \code{\link{netplot}} for these
  data-frames.
}
\description{
Calculates the necessary elements to describe the evidence base
  for an outcome across the network, the interventions, and observed
  comparisons. See also 'Value' in \code{\link{netplot}}.
}
\details{
\code{describe_network} calls \code{\link{data_preparation}} to
facilitate the calculations.
}
\seealso{
\code{\link{data_preparation}}, \code{\link{netplot}},
  \code{\link{run_model}},
}
\author{
{Loukia M. Spineli}
}
