% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.preparation_function.R
\name{data_preparation}
\alias{data_preparation}
\title{Prepare the dataset in the proper format for R2jags}
\usage{
data_preparation(data, measure)
}
\arguments{
\item{data}{A data-frame of the one-trial-per-row format with arm-level data.
See 'Format' in \code{\link{run_model}}.}

\item{measure}{Character string indicating the effect measure with values
\code{"OR"}, \code{"MD"}, \code{"SMD"}, or \code{"ROM"} for the odds ratio,
mean difference, standardised mean difference and ratio of means,
respectively.}
}
\value{
A list of data-frames on the following elements to be passed
  to \code{\link{run_model}}:
  \tabular{ll}{
   \code{m} \tab The number of missing participant outcome data in each
   trial-arm (see 'Details' in the \code{\link{run_model}} function).\cr
   \tab \cr
   \code{N} \tab The number of randomised participants in each trial-arm.\cr
   \tab \cr
   \code{t} \tab The intervention identifier in each trial-arm.\cr
   \tab \cr
   \code{I} \tab The pseudo-data-frame \code{I} (see 'Details'
   in \code{\link{run_model}}).\cr
   \tab \cr
   \code{r} \tab The observed number of events of the outcome in each
   trial-arm,
   when the outcome is binary.\cr
   \tab \cr
   \code{y0} \tab The observed mean value of the outcome in each trial-arm,
   when the outcome is continuous\cr
   \tab \cr
   \code{se0} \tab The observed standard deviation of the outcome in each
   trial-arm,
   when the outcome is continuous\cr
  }
}
\description{
\code{data_preparation} prepares the dataset in the proper format for
  R2jags ans returns a list of elements that \code{\link{run_model}} inherits
  via the argument \code{data}.
}
\details{
\code{data_preparation} prepares the data for the Bayesian analysis.
  \code{data_preparation} checks whether the element \strong{m} exists in the
  \code{data} argument (See 'Format' in \code{\link{run_model}}). If this
  element is missing, \code{data_preparation} creates a pseudo-data-frame for
  \strong{m} that has the zero value for the observed trial-arms, and
  \code{NA} for the unobserved trial-arms, and the pseudo-data-frame \code{I}
  that is identical with the pseudo-data-frame for \code{m}. If the element
  \strong{m} exists in the \code{data} and has values only for some
  trial-arms, the pseudo-data-frame for \strong{m} is identical to \strong{m}
  for the corresponding trial-arms, and the pseudo-data-frame \code{I} has
  the value one for these trial-arms. Both pseudo-data-frames aim to retain
  the trials without information on missing participant outcome data.

  Furthermore, \code{data_preparation} sorts the interventions across
  the arms of each trial in an ascending order and correspondingly the
  remaining elements in \code{data} (See 'Format' in
  \code{\link{run_model}}). \code{data_preparation} considers the first
  column in \strong{t} as being the control arm for every trial. Thus,
  this sorting ensures that interventions with a lower identifier are
  consistently treated as the control arm in each trial. This case is
  relevant in non-star-shaped networks.
}
\seealso{
\href{https://CRAN.R-project.org/package=R2jags}{R2jags},
  \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
