% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint_goldprice.R
\name{get_todays_goldprice}
\alias{get_todays_goldprice}
\title{Retrieves the gold price that was published today.}
\usage{
get_todays_goldprice()
}
\value{
nbp_api_response object containing today's gold price.
}
\description{
Retrieves the gold price that was published today.
}
\details{
If today's data is not available the API will
return a 404 Not found error. In that case the function will
return an error with an appropriate message.
}
\examples{

\donttest{
  tryCatch({
      ## Fetch todays gold price
      response <- get_todays_goldprice()
      ## Preview response content
      response$content
    },
    error = function(e) message(e)
  )
}

}
\seealso{
\url{https://api.nbp.pl/#cenyZlota}

Other goldprice: 
\code{\link{get_current_goldprice}()},
\code{\link{get_goldprice_from_interval}()},
\code{\link{get_goldprice_from}()},
\code{\link{get_last_n_goldprices}()}
}
\concept{goldprice}
