% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversion.R
\name{filenameToCV}
\alias{filenameToCV}
\title{For a given filename (e.g. "test.mzML"), check the suffix and translate it to an PSI-MS CV term, e.g. 'MS:1000584'}
\usage{
filenameToCV(filepath)
}
\arguments{
\item{filepath}{A filename (with optional path)}
}
\value{
A CV term accession as string, e.g. 'MS:1000584'
}
\description{
The following mapping is currently known:
.raw    : MS:1000563 ! Thermo RAW format
.mzML   : MS:1000584 ! mzML format
.mzData : MS:1000564 ! PSI mzData format
.wiff   : MS:1000562 ! ABI WIFF format
.pkl    : MS:1000565 ! Micromass PKL format
.mzXML  : MS:1000566 ! ISB mzXML format
.yep    : MS:1000567 ! Bruker/Agilent YEP format
.dta    : MS:1000613 ! Sequest DTA format
.mzMLb  : MS:1002838 ! mzMLb format
}
\details{
Falls back to 'MS:1000560 ! mass spectrometer file format' if no match could be found.

Upper/lowercase is ignored, i.e. "mzML == mzml".
}
\examples{
  filenameToCV("test.mZmL")  # MS:1000584
  filenameToCV("test.raw")  # MS:1000563
  filenameToCV(c("test.raw", "bla.mzML"))

}
