% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obo.R
\name{CV_}
\alias{CV_}
\title{Define a Singleton class which can hold a CV dictionary (so we do not have to load the .obo files over and over again)}
\description{
Define a Singleton class which can hold a CV dictionary (so we do not have to load the .obo files over and over again)

Define a Singleton class which can hold a CV dictionary (so we do not have to load the .obo files over and over again)
}
\details{
You can set your own custom CV by calling 'setData()'. By default, the latest release of the PSI-MS-CV (see \code{\link{getCVDictionary}}).

Usage:
cv_dict = CV_$new() ## uses 'getCVDictionary()' to populate the singleton
cv_2 = CV_$new() ## uses the same data without parsing again
cv_2$setData(getCVDictionary("custom", "https://my.com/custom.obo))

Wherever you need this data, simply re-grab the singleton using 'CV_$new()$data' (or use the convenience function getCVSingleton()$data from outside the package)
}
\section{Super class}{
\code{\link[R6P:Singleton]{R6P::Singleton}} -> \code{CV_}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{Stores the data of the singleton.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CV_-byID}{\code{CV_$byID()}}
\item \href{#method-CV_-setData}{\code{CV_$setData()}}
\item \href{#method-CV_-getCV}{\code{CV_$getCV()}}
\item \href{#method-CV_-clone}{\code{CV_$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="R6P" data-topic="Singleton" data-id="initialize"><a href='../../R6P/html/Singleton.html#method-Singleton-initialize'><code>R6P::Singleton$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-byID"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-byID}{}}}
\subsection{Method \code{byID()}}{
A function to retrieve a CV using its ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$byID(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{A CV accession, e.g. 'MS:1000560'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-setData"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-setData}{}}}
\subsection{Method \code{setData()}}{
Set a user-defined object (consisting of 'CV', 'URI' and 'version'), as obtained from \code{\link{getCVDictionary}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$setData(cv_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cv_data}}{The result of a call to \code{\link{getCVDictionary}}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-getCV"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-getCV}{}}}
\subsection{Method \code{getCV()}}{
Gets the CV data, i.e. the 'CV' part of this class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$getCV()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CV_-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CV_-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CV_$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
