% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_reference_points.R
\name{scale_reference_directions}
\alias{scale_reference_directions}
\title{Scale Reference Points}
\usage{
scale_reference_directions(ref_dirs, scaling)
}
\arguments{
\item{ref_dirs, scaling}{where 'ref_dirs' are the reference points generated and
'scaling' are the scale on which the points are distributed.}
}
\value{
A matrix with rescaled reference points uniformly distributed.
}
\description{
A implementation of Das and Dennis's Reference Points Generation.
}
\details{
The implemented Reference Point Generation is based on the Das and Dennis's
systematic approach that places points on a normalized hyper-plane which is
equally inclined to all objective axes and has an intercept of one on each axis.
}
\references{
J. Blank and K. Deb, "Pymoo: Multi-Objective Optimization in Python," in
IEEE Access, vol. 8, pp. 89497-89509, 2020, doi: 10.1109/ACCESS.2020.2990567.
}
\seealso{
\code{\link[=generate_reference_points]{generate_reference_points()}} and \code{\link[=get_fixed_rowsum_integer_matrix]{get_fixed_rowsum_integer_matrix()}}
}
\author{
Francisco Benitez
\email{benitezfj94@gmail.com}
}
