% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/access.R
\name{rmonad_getters}
\alias{rmonad_getters}
\alias{get_parents}
\alias{get_dependents}
\alias{get_nest}
\alias{get_prior}
\alias{get_depth}
\alias{get_nest_depth}
\alias{get_value}
\alias{get_key}
\alias{get_id}
\alias{get_OK}
\alias{get_code}
\alias{get_tag}
\alias{get_error}
\alias{get_warnings}
\alias{get_notes}
\alias{get_doc}
\alias{get_meta}
\alias{get_time}
\alias{get_mem}
\alias{get_summary}
\title{Vectorized getters for public Rmonad fields}
\usage{
get_parents(m, index = .get_ids(m), tag = NULL)

get_dependents(m, index = .get_ids(m), tag = NULL)

get_nest(m, index = .get_ids(m), tag = NULL)

get_prior(m, index = .get_ids(m), tag = NULL)

get_depth(m, index = .get_ids(m), tag = NULL)

get_nest_depth(m, index = .get_ids(m), tag = NULL)

get_value(m, index = .get_ids(m), tag = NULL, warn = TRUE)

get_key(m, index = .get_ids(m), tag = NULL)

get_id(m, index = .get_ids(m), tag = NULL)

get_OK(m, index = .get_ids(m), tag = NULL)

get_code(m, index = .get_ids(m), tag = NULL)

get_tag(m, index = .get_ids(m), tag = NULL)

get_error(m, index = .get_ids(m), tag = NULL)

get_warnings(m, index = .get_ids(m), tag = NULL)

get_notes(m, index = .get_ids(m), tag = NULL)

get_doc(m, index = .get_ids(m), tag = NULL)

get_meta(m, index = .get_ids(m), tag = NULL)

get_time(m, index = .get_ids(m), tag = NULL)

get_mem(m, index = .get_ids(m), tag = NULL)

get_summary(m, index = .get_ids(m), tag = NULL)
}
\arguments{
\item{m}{An Rmonad object}

\item{index}{Selection of indices to extract (all by default). The indices
may be a vector of integers, node names, or igraph vertices
(\code{igraph.vs}).}

\item{tag}{character vector specifying the tags that must be associated with extracted nodes}

\item{warn}{logical In get_value, raise a warning on an attempt to access an uncached node}
}
\description{
Vectorized getters for public Rmonad fields
}
\examples{
data(gff)
m <- gff$good_result

# vectorized accessors for all stored slots
get_value(m, warn=FALSE)
get_OK(m)
get_code(m)
get_dependents(m)
get_doc(m)
get_error(m)
get_id(m)
get_mem(m)
get_meta(m)
get_nest(m)
get_nest_depth(m)
get_notes(m)
get_parents(m)
get_prior(m)
get_summary(m)
get_time(m)
get_warnings(m)

# get the code associated with long running functions
get_code(m)[get_time(m) > 0.1]

# Calculate the average node degree
nparents <- sapply(get_parents(m), length)
nchildren <- sapply(get_dependents(m), length)
sum(nparents + nchildren) / size(m) 
}
