/*
 * Decompiled with CFR 0.152.
 */
package dmLab.discretizer;

import dmLab.array.FArray;
import dmLab.classifier.Params;
import java.util.Properties;

public final class DiscretizerParams
extends Params {
    public int discAlgorithm;
    public int discIntervals;
    public float maxSimilarity;

    public DiscretizerParams() {
        this.fileType = "cfg";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append("### Discretizer Parameters ### \n");
        tmp.append("discAlgorithm=" + this.discAlgorithm).append('\n');
        tmp.append("discIntervals=" + this.discIntervals).append('\n');
        tmp.append("maxSimilarity=" + this.maxSimilarity).append('\n');
        tmp.append("verbose=" + this.verbose).append('\n');
        return var1_1.toString();
    }

    @Override
    public final boolean setDefault() {
        this.discAlgorithm = 5;
        this.discIntervals = 4;
        this.maxSimilarity = 0.5f;
        this.verbose = false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean update(Properties properties) {
        void var1_1;
        this.discAlgorithm = Integer.valueOf(properties.getProperty("discAlgorithm", "5"));
        this.discIntervals = Integer.valueOf(properties.getProperty("discIntervals", "4"));
        this.maxSimilarity = Float.valueOf(properties.getProperty("maxSimilarity", "0.5")).floatValue();
        this.verbose = Boolean.valueOf(var1_1.getProperty("verbose", "false"));
        return this.check(null);
    }

    @Override
    public final boolean check(FArray array) {
        if (this.discIntervals <= 0) {
            System.err.println("Error! Incorrect discRanges.");
            return false;
        }
        if (this.discAlgorithm <= 0 || this.discAlgorithm > 10) {
            System.err.println("Error! Incorrect discretizationType.");
            return false;
        }
        return true;
    }
}

