/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.Function;
import weka.core.pmml.TransformationDictionary;

public class DefineFunction
extends Function {
    private static final long serialVersionUID = -1976646917527243888L;
    protected ArrayList<ParameterField> m_parameters = new ArrayList();
    FieldMetaInfo.Optype m_optype = FieldMetaInfo.Optype.NONE;
    protected Expression m_expression = null;

    public DefineFunction(Element container, TransformationDictionary transDict) throws Exception {
        this.m_functionName = container.getAttribute("name");
        String opType = container.getAttribute("optype");
        if (opType != null && opType.length() > 0) {
            FieldMetaInfo.Optype[] optypeArray = FieldMetaInfo.Optype.values();
            int n = optypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                FieldMetaInfo.Optype o = optypeArray[n2];
                if (o.toString().equals(opType)) {
                    this.m_optype = o;
                    break;
                }
                ++n2;
            }
        } else {
            throw new Exception("[DefineFunction] no optype specified!!");
        }
        this.m_parameterDefs = new ArrayList();
        NodeList paramL = container.getElementsByTagName("ParameterField");
        int i = 0;
        while (i < paramL.getLength()) {
            Node paramN = paramL.item(i);
            if (paramN.getNodeType() == 1) {
                ParameterField newP = new ParameterField((Element)paramN);
                this.m_parameters.add(newP);
                this.m_parameterDefs.add(newP.getFieldAsAttribute());
            }
            ++i;
        }
        this.m_expression = Expression.getExpression(container, this.m_optype, this.m_parameterDefs, transDict);
        if (this.m_optype == FieldMetaInfo.Optype.CONTINUOUS && this.m_expression.getOptype() != this.m_optype) {
            throw new Exception("[DefineFunction] optype is continuous but our Expression's optype is not.");
        }
        if ((this.m_optype == FieldMetaInfo.Optype.CATEGORICAL || this.m_optype == FieldMetaInfo.Optype.ORDINAL) != (this.m_expression.getOptype() == FieldMetaInfo.Optype.CATEGORICAL || this.m_expression.getOptype() == FieldMetaInfo.Optype.ORDINAL)) {
            throw new Exception("[DefineFunction] optype is categorical/ordinal but our Expression's optype is not.");
        }
    }

    @Override
    public Attribute getOutputDef() {
        return this.m_expression.getOutputDef();
    }

    @Override
    public String[] getParameterNames() {
        String[] result = new String[this.m_parameters.size()];
        int i = 0;
        while (i < this.m_parameters.size()) {
            result[i] = this.m_parameters.get(i).getFieldName();
            ++i;
        }
        return result;
    }

    @Override
    public double getResult(double[] incoming) throws Exception {
        if (incoming.length != this.m_parameters.size()) {
            throw new IllegalArgumentException("[DefineFunction] wrong number of arguments: expected " + this.m_parameters.size() + ", recieved " + incoming.length);
        }
        return this.m_expression.getResult(incoming);
    }

    @Override
    public void setParameterDefs(ArrayList<Attribute> paramDefs) throws Exception {
        if (paramDefs.size() != this.m_parameters.size()) {
            throw new Exception("[DefineFunction] number of parameter definitions does not match number of parameters!");
        }
        int i = 0;
        while (i < this.m_parameters.size()) {
            if (this.m_parameters.get(i).getOptype() == FieldMetaInfo.Optype.CONTINUOUS) {
                if (!paramDefs.get(i).isNumeric()) {
                    throw new Exception("[DefineFunction] parameter " + this.m_parameters.get(i).getFieldName() + " is continuous, but corresponding " + "supplied parameter def " + paramDefs.get(i).name() + " is not!");
                }
            } else if (!paramDefs.get(i).isNominal() && !paramDefs.get(i).isString()) {
                throw new Exception("[DefineFunction] parameter " + this.m_parameters.get(i).getFieldName() + " is categorical/ordinal, but corresponding " + "supplied parameter def " + paramDefs.get(i).name() + " is not!");
            }
            ++i;
        }
        ArrayList<Attribute> newParamDefs = new ArrayList<Attribute>();
        int i2 = 0;
        while (i2 < paramDefs.size()) {
            Attribute a = paramDefs.get(i2);
            newParamDefs.add(a.copy(this.m_parameters.get(i2).getFieldName()));
            ++i2;
        }
        this.m_parameterDefs = newParamDefs;
        this.m_expression.setFieldDefs(this.m_parameterDefs);
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String pad) {
        StringBuffer buff = new StringBuffer();
        buff.append(String.valueOf(pad) + "DefineFunction (" + this.m_functionName + "):\n" + pad + "nparameters:\n");
        for (ParameterField p : this.m_parameters) {
            buff.append(String.valueOf(pad) + p.getFieldAsAttribute() + "\n");
        }
        buff.append(String.valueOf(pad) + "expression:\n" + this.m_expression.toString(String.valueOf(pad) + "  "));
        return buff.toString();
    }

    protected class ParameterField
    extends FieldMetaInfo {
        private static final long serialVersionUID = 3918895902507585558L;

        protected ParameterField(Element field) {
            super(field);
        }

        @Override
        public Attribute getFieldAsAttribute() {
            if (this.m_optype == FieldMetaInfo.Optype.CONTINUOUS) {
                return new Attribute(this.m_fieldName);
            }
            return new Attribute(this.m_fieldName, null);
        }
    }
}

