% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/word_document.R
\name{word_document}
\alias{word_document}
\title{Convert to an MS Word document}
\usage{
word_document(toc = FALSE, toc_depth = 3, fig_width = 5, fig_height = 4,
  fig_caption = TRUE, df_print = "default", highlight = "default",
  reference_docx = "default", keep_md = FALSE, md_extensions = NULL,
  pandoc_args = NULL)
}
\arguments{
\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_depth}{Depth of headers to include in table of contents}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method uses
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition
to the named methods you can also pass an arbitrary function to be used
for printing data frames. You can disable the df_print behavior entirely
by setting the option \code{rmarkdown.df_print} to \code{FALSE}.}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", and "haddock". Pass \code{NULL} to prevent syntax highlighting.}

\item{reference_docx}{Use the specified file as a style reference in
producing a docx file. For best results, the reference docx should be a
modified version of a docx file produced using pandoc. Pass "default"
to use the rmarkdown default styles.}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to an MS Word document.
}
\details{
See the \href{http://rmarkdown.rstudio.com/word_document_format.html}{online
documentation} for additional details on using the \code{word_document} format.

R Markdown documents can have optional metadata that is used to generate a
document header that includes the title, author, and date. For more details
see the documentation on R Markdown \link[=rmd_metadata]{metadata}.

R Markdown documents also support citations. You can find more information on
the markdown syntax for citations in the
\href{http://rmarkdown.rstudio.com/authoring_bibliographies_and_citations.html}{Bibliographies
and Citations} article in the online documentation.
}
\examples{
\dontrun{

library(rmarkdown)

# simple invocation
render("input.Rmd", word_document())

# specify an option for syntax highlighting
render("input.Rmd", word_document(highlight = "zenburn"))
}

}
