% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_taxonomy.R
\name{search_taxonomy}
\alias{search_taxonomy}
\title{Query taxonomy}
\usage{
search_taxonomy(
  query,
  tsn = NULL,
  gbif = NULL,
  eol = NULL,
  col = NULL,
  bold = NULL,
  ncbi = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{query}{a character string including a single keyword.
Note that if an empty character string is passed, then all datasets available are returned.}

\item{tsn}{a \code{numeric}. Unique taxonomic identifier from Integrated Taxonomic Information System (\url{https://www.itis.gov}).}

\item{gbif}{a \code{numeric}. Unique taxonomic identifier from Global Biodiversity Information Facility (\url{https://www.gbif.org}).}

\item{eol}{a \code{numeric}. Unique taxonomic identifier from Encyclopedia of Life (\url{https://eol.org}).}

\item{col}{a \code{numeric}. Unique taxonomic identifier from Catalogue of Life (\url{https://www.catalogueoflife.org}).}

\item{bold}{a \code{numeric}. Unique taxonomic identifier from Barcode of Life (\url{http://www.boldsystems.org}).}

\item{ncbi}{a \code{numeric}. Unique taxonomic identifier from National Center for Biotechnology Information (\url{https://www.ncbi.nlm.nih.gov}).}

\item{verbose}{a \code{logical}. Should extra information be reported on progress?}

\item{...}{further arguments to be passed to \code{\link[httr:GET]{httr::GET()}}.}
}
\value{
An object of class \code{mgSearchTaxonomy}, which is a \code{data.frame} including
all taxa matching the query.
}
\description{
Search network by taxon names and unique taxonomic identifiers.
This function offers the opportunity to retrieve taxon based on (i) known identifier
such as the taxonomic serial number (TSN), GBIF ID etc. or (ii) text search using partial match.
Have a look at the list of arguments to see the complete list of identifiers accessible.
If any unique identifier argument is used (i.e. tsn etc.), then \code{query} is ignored. Moreover,
if several taxonomic identifiers are specified, then only the first one is considered.
}
\details{
Taxon names of the \code{taxonomy} table were validated with
TNRS (see \url{https://tnrs.biendata.org} and/or GNR
might not be the taxon name documented in the original publication.
In order to identify relevant networks with the original name, use
\code{\link[=search_nodes]{search_nodes()}}.

The validation of taxon names was performed by an automated
procedure and if there is any doubt, the original names recorded
by authors should be regarded as the most reliable information. Please
report any issue related to taxonomy at \url{https://github.com/mangal-interactions/contribute/issues/new/choose/}.
}
\examples{
\donttest{
 search_taxonomy("Acer")
 # Retrieve higher classification
 tsn_acer <- search_taxonomy("Acer")$taxonomy.tsn
}
}
\references{
\itemize{
\item \url{https://mangal.io/#/}
\item \url{https://mangal-interactions.github.io/mangal-api/#taxonomy}
}
}
\seealso{
\code{\link[=search_nodes]{search_nodes()}}
}
