% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlistings.R
\name{matrix_form,listing_df-method}
\alias{matrix_form,listing_df-method}
\title{Transform \code{rtable} to a list of matrices which can be used for outputting}
\usage{
\S4method{matrix_form}{listing_df}(obj, indent_rownames = FALSE)
}
\arguments{
\item{obj}{ANY. Object to be transformed into a ready-to-render form (a \code{MatrixPrintForm} object)}

\item{indent_rownames}{logical(1). Silently ignored, as listings do not have row names
nor indenting structure.}
}
\value{
a \code{MatrixPrintForm} object
}
\description{
Although \code{rtables} are represented as a tree data structure when outputting the table to ASCII or HTML it is useful to
map the \code{rtable} to an in between state with the formatted cells in a matrix form.
}
\details{
The strings in the return object are defined as follows: row labels are those determined by \code{summarize_rows} and
cell values are determined using \code{get_formatted_cells}.
(Column labels are calculated using a non-exported internal function.
}
\examples{

lsting <- as_listing(mtcars)
mf <- matrix_form(lsting)

}
\seealso{
\code{\link[formatters:matrix_form]{formatters::matrix_form()}}
}
