% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/list.take.R
\name{list.takeWhile}
\alias{list.takeWhile}
\title{Keep taking elements while a condition holds}
\usage{
list.takeWhile(.data, cond)
}
\arguments{
\item{.data}{\code{list} or \code{vector}}

\item{cond}{A logical lambda expression}
}
\description{
Keep taking elements out from a list or vector while
a condition holds for the element. If the condition is
violated for an element, the element will not be taken and
all taken elements will be returned.
}
\examples{
x <- list(p1 = list(type='A',score=list(c1=10,c2=8)),
       p2 = list(type='B',score=list(c1=9,c2=9)),
       p3 = list(type='B',score=list(c1=9,c2=7)))
list.takeWhile(x, type=='B')
list.takeWhile(x, min(score$c1,score$c2) >= 8)
}
\seealso{
\code{\link{list.take}}, \code{\link{list.skip}},
\code{\link{list.skipWhile}}
}

