% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEG_marker.R
\name{plotPairwiseDEGHeatmap}
\alias{plotPairwiseDEGHeatmap}
\title{Create heatmap for pairwise DEG analysis result}
\usage{
plotPairwiseDEGHeatmap(
  object,
  result,
  group = NULL,
  topN = 20,
  absLFCThresh = 1,
  padjThresh = 0.05,
  pctInThresh = 50,
  pctOutThresh = 50,
  downsampleSize = 200,
  useCellMeta = NULL,
  column_title = NULL,
  seed = 1,
  ...
)
}
\arguments{
\item{object}{A \linkS4class{liger} object, with normalized data and metadata
to annotate available.}

\item{result}{The data.frame returned by \code{\link{runPairwiseDEG}}.}

\item{group}{The test group name among the result to be shown. Must specify
only one if multiple tests are available (i.e. split test). Default
\code{NULL} works with single-test result and raises error with split-test
result.}

\item{topN}{Maximum number of top significant features to be plot for up- and
down-regulated genes. Default \code{20}.}

\item{absLFCThresh}{Hard threshold on absolute logFC value. Default \code{1}.}

\item{padjThresh}{Hard threshold on adjusted P-value. Default \code{0.05}.}

\item{pctInThresh, pctOutThresh}{Threshold on expression percentage. These
mean that a feature will only pass the filter if it is expressed in more than
\code{pctInThresh} percent of cells in the corresponding cluster. Similarly
for \code{pctOutThresh}. Only applied when these metrics are available.
Default \code{50} percent for both.}

\item{downsampleSize}{Maximum number of downsampled cells to be shown in the
heatmap. The downsampling is balanced on the cells involved in the test
specified. Default \code{200}.}

\item{useCellMeta}{Cell metadata variable names for cell grouping. Default
\code{NULL} includes dataset source and the default cluster.}

\item{column_title}{Title on the column. Default \code{NULL}.}

\item{seed}{Random seed for reproducibility. Default \code{1}.}

\item{...}{
  Arguments passed on to \code{\link[=.plotHeatmap]{.plotHeatmap}}
  \describe{
    \item{\code{transpose}}{Logical, whether to "rotate" the heatmap by 90 degrees so
that cell information is displayed by row. Default \code{FALSE}.}
    \item{\code{showCellLabel,showFeatureLabel}}{Logical, whether to show cell barcodes,
gene symbols or factor names. Default \code{TRUE} for gene/factors but
\code{FALSE} for cells.}
    \item{\code{cellAnnColList,featureAnnColList}}{List object, with each element a
named vector of R-interpretable color code. The names of the list elements
are used for matching the annotation variable names. The names of the colors
in the vectors are used for matching the levels of a variable (factor object,
categorical). Default \code{NULL} generates ggplot-flavor categorical colors.}
    \item{\code{scale}}{Logical, whether to take z-score to scale and center gene
expression. Applied after \code{dataScaleFunc}. Default \code{FALSE}.}
    \item{\code{trim}}{Numeric vector of two values. Limit the z-score value into this
range when \code{scale = TRUE}. Default \code{c(-2, 2)}.}
    \item{\code{baseSize}}{One-parameter control of all text sizes. Individual text
element sizes can be controlled by other size arguments. "Title" sizes are
2 points larger than "text" sizes when being controlled by this.}
    \item{\code{cellTextSize,featureTextSize,legendTextSize}}{Size of cell barcode
labels, gene/factor labels, or legend values. Default \code{NULL}.}
    \item{\code{cellTitleSize,featureTitleSize,legendTitleSize}}{Size of titles of the
cell slices, gene/factor slices, or the legends. Default \code{NULL}.}
    \item{\code{viridisOption,viridisDirection}}{See argument \code{option} and
\code{direction} of \code{\link[viridisLite]{viridis}}. Default \code{"A"}
and \code{-1}.}
    \item{\code{RColorBrewerOption}}{When \code{scale = TRUE}, heatmap color will be
mapped with \code{\link[RColorBrewer]{brewer.pal}}. This is passed to
\code{name}. Default \code{"RdBu"}.}
  }}
}
\value{
A \link[ComplexHeatmap]{HeatmapList-class} object.
}
\description{
Create heatmap for pairwise DEG analysis result
}
\examples{
defaultCluster(pbmc) <- pbmcPlot$leiden_cluster
pbmc$condition_cluster <- interaction(pbmc$dataset, pbmc$defaultCluster)
deg <- runPairwiseDEG(pbmc, 'stim.0', 'stim.1', 'condition_cluster')
pbmc <- normalize(pbmc)
plotPairwiseDEGHeatmap(pbmc, deg, 'stim.0')
}
