% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{ligerToSeurat}
\alias{ligerToSeurat}
\title{Create a Seurat object containing the data from a liger object}
\usage{
ligerToSeurat(
  object,
  nms = names(object@H),
  renormalize = TRUE,
  use.liger.genes = TRUE,
  by.dataset = FALSE
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{nms}{By default, labels cell names with dataset of origin (this is to account for cells in
different datasets which may have same name). Other names can be passed here as vector, must
have same length as the number of datasets. (default names(H))}

\item{renormalize}{Whether to log-normalize raw data using Seurat defaults (default TRUE).}

\item{use.liger.genes}{Whether to carry over variable genes (default TRUE).}

\item{by.dataset}{Include dataset of origin in cluster identity in Seurat object (default FALSE).}
}
\value{
Seurat object with raw.data, scale.data, dr$tsne, dr$inmf, and ident slots set.
}
\description{
Merges raw.data and scale.data of object, and creates Seurat object with these values along with
tsne.coords, iNMF factorization, and cluster assignments. Supports Seurat V2 and V3.
}
\details{
Stores original dataset identity by default in new object metadata if dataset names are passed
in nms. iNMF factorization is stored in dim.reduction object with key "iNMF".
}
\examples{
\dontrun{
# ligerex (liger object based on in-memory datasets ONLY), factorization complete input
s.object <- ligerToSeurat(ligerex)
}
}
