% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{copy.Kriging}
\alias{copy.Kriging}
\alias{copy,Kriging,Kriging-method}
\title{Duplicate a Kriging Model}
\usage{
\method{copy}{Kriging}(object, ...)
}
\arguments{
\item{object}{An S3 Kriging object.}

\item{...}{Not used.}
}
\value{
The copy of object.
}
\description{
Duplicate a Kriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective="LMP")
print(k)

print(copy(k))
}
\author{
Yann Richet \email{yann.richet@asnr.fr}
}
