% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/travellingsalespersonproblem.R
\name{TravelingSalesperson}
\alias{TravelingSalesperson}
\alias{TravellingSalesperson}
\title{TravelingSalespersonProblem}
\usage{
TravelingSalesperson(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999,
  algorithm = "Christofides"
)

TravellingSalesperson(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999,
  algorithm = "Christofides"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of a graph's edges}

\item{numNodes}{The number of nodes in the graph}

\item{defaultEdgeWeight}{The default edge weight if an edge is not-specified
(default value 999999)}

\item{algorithm}{Which algorithm to run. Choices include
"Christofides","Greedy","Insertion","NearestNeighbor","Opt2". Christofides
is the default; see <https://lemon.cs.elte.hu/pub/doc/1.3.1/a00618.html>
for details on the differences.}
}
\value{
a List with 1) the list of tour vertices, and 2) the total tour cost
}
\description{
Finds approximations for the travelling salesperson problem using
approximation algorithms on graphs. NOTE: LEMON's TSP uses a
complete graph in its backend, so expect less performance on sparse graphs.
}
