% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Planar-Embedding-Algorithms}
\alias{Planar-Embedding-Algorithms}
\alias{PlanarCheckingRunner}
\alias{PlanarColoringRunner}
\alias{PlanarDrawingRunner}
\title{Planar Embedding Algorithms}
\usage{
PlanarCheckingRunner(arcSources, arcTargets, numNodes)

PlanarColoringRunner(arcSources, arcTargets, numNodes, useFiveAlg = TRUE)

PlanarDrawingRunner(arcSources, arcTargets, numNodes)
}
\arguments{
\item{arcSources, }{a vector corresponding to the source nodes of a graph's edges}

\item{arcTargets, }{a vector corresponding to the destination nodes of a graph's edges}

\item{numNodes, }{the number of nodes in the graph}

\item{useFiveAlg, }{a boolean that asks if you want to 5-color a graph. If false, runs a faster 6-coloring algorithm instead.}
}
\value{
assorted values, depending on the function
}
\description{
`PlanarCheckingRunner` returns a boolean stating if a graph is planar or not.

`PlanarColoringRunner` returns a List containing 1) a Boolean stating if a graph is planar or not, 2) a vector containing the colors of each node, represented as integers

`PlanarCheckingRunner` returns a List containing 1) a boolean stating if a graph is planar or not, 2) a vector containing the x-coordinates of each node and 3) a vector containing the y-coordinates of each node
}
