% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Maximum-Mean-Cycle-Algorithms}
\alias{Maximum-Mean-Cycle-Algorithms}
\alias{HowardMmcRunner}
\alias{KarpMmcRunner}
\alias{HartmannOrlinMmcRunner}
\title{Minimum Mean-Cycle Algorithms}
\usage{
HowardMmcRunner(arcSources, arcTargets, arcDistances, numNodes)

KarpMmcRunner(arcSources, arcTargets, arcDistances, numNodes)

HartmannOrlinMmcRunner(arcSources, arcTargets, arcDistances, numNodes)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's edges}

\item{arcDistances}{Vector corresponding to the distances of a graph's edges}

\item{numNodes}{The number of nodes in the graph}
}
\value{
A list containing two entries: 1) A vector containing the costs of each edge in the MMC, and 2) the nodes in the MMC.
}
\description{
`HowardMmcRunner` runs Howard's policy iteration algorithm to find a directed cycle of minimum mean cost.

`KarpMmcRunner` runs Karp's algorithm to find a directed cycle of minimum mean cost .

`HartmannOrlinMmcRunner` runs Hartmann-Orlin's algorithm to find a directed cycle of minimum mean cost .
}
