% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_hist}
\alias{lc_hist}
\alias{lc_dens}
\title{Histograms and density plots}
\usage{
lc_hist(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  with = NULL,
  addLayer = FALSE
)

lc_dens(
  data = list(),
  place = NULL,
  ...,
  chartId = NULL,
  layerId = NULL,
  with = NULL,
  addLayer = FALSE
)
}
\arguments{
\item{data}{Name-value pairs of properties passed through the \code{\link{dat}} function. These
properties will be re-evaluated on each \code{\link{updateCharts}} call.}

\item{place}{An ID of the container, where to place new chart. It will be ignored if the chart already
exists. If not defined, the chart will be appended to the web page's body.}

\item{...}{Name-value pairs of properties that will be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function.}

\item{chartId}{An ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, it will be replaced unless \code{addLayer = TRUE}. If ID is not defined, it will be the same as the
value of the \code{place} argument. And if both are not defined, the ID will be set to \code{ChartN},
where \code{N - 1} is the number of existing charts.}

\item{layerId}{An ID for the new layer. All layers within one chart must have different IDs. If a layer with the same
ID already exists, it will be replaced. If not defined, it will be set to \code{LayerN}, where \code{N - 1}
is the current number of layers in this chart.}

\item{with}{A dataset or a list from which other properties should be taken. If the dataset doesn't have a
column with the requested name, the variable will be searched for outside of the dataset. It must be
a \code{data.frame} or a \code{list}.}

\item{addLayer}{If there is already a chart with the same ID, this argument defines whether to replace it or to add a
new layer to it. This argument is ignored if both \code{place} and \code{chartId} are \code{NULL} or if there is no
chart with the given ID.}
}
\description{
These functions make either a histogram or a density plot of the given data
and either add them as a new layer to an existing chart or create a new chart.
}
\section{Functions}{
\itemize{
\item \code{lc_hist}: makes a histogram. It is an extension of \code{\link{lc_bars}}.

\item \code{lc_dens}: makes a density plot. Is an extension of \code{\link{lc_line}}.
}}

\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{value} - vector of data values.
\item \code{nbins} - (only for \code{lc_hist}) number of bins.}

These functions are extensions of \code{\link{lc_line}} (\code{lc_dens}) or \code{\link{lc_bars}}
(\code{lc_hist}) and therefore also accept all their properties.
}

\examples{
\donttest{
lc_hist(dat(value = rnorm(1000), nbins = 30, height = 300))
lc_dens(dat(value = rnorm(1000), height = 300)) }

}
