% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-restarts.R
\name{rst_list}
\alias{rst_list}
\alias{rst_exists}
\alias{rst_jump}
\alias{rst_maybe_jump}
\title{Restarts utilities}
\usage{
rst_list()

rst_exists(.restart)

rst_jump(.restart, ...)

rst_maybe_jump(.restart, ...)
}
\arguments{
\item{.restart}{The name of a restart.}

\item{...}{Arguments passed on to the restart function. These
dots support \link[=tidy-dots]{tidy dots} features.}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("questioning")}

Restarts are named jumping points established by \code{\link[=with_restarts]{with_restarts()}}.
\code{rst_list()} returns the names of all restarts currently
established. \code{rst_exists()} checks if a given restart is
established. \code{rst_jump()} stops execution of the current function
and jumps to a restart point. If the restart does not exist, an
error is thrown.  \code{rst_maybe_jump()} first checks that a restart
exists before jumping.
}
\section{Life cycle}{


All the restart functions are in the questioning stage. It is not
clear yet whether we want to recommend restarts as a style of
programming in R.
}

\seealso{
\code{\link[=with_restarts]{with_restarts()}}
}
