% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd.R
\name{cnd_muffle}
\alias{cnd_muffle}
\title{Muffle a condition}
\usage{
cnd_muffle(cnd)
}
\arguments{
\item{cnd}{A condition to muffle.}
}
\description{
Unlike \code{\link[=exiting]{exiting()}} handlers, \code{\link[=calling]{calling()}} handlers must be explicit
that they have handled a condition to stop it from propagating to
other handlers. Use \code{cnd_muffle()} within a calling handler (or as
a calling handler, see examples) to prevent any other handlers from
being called for that condition.
}
\section{Mufflable conditions}{


Most conditions signalled by base R are muffable, although the name
of the restart varies. cnd_muffle() will automatically call the
correct restart for you. It is compatible with the following
conditions:
\itemize{
\item \code{warning} and \code{message} conditions. In this case \code{cnd_muffle()}
is equivalent to \code{\link[base:suppressMessages]{base::suppressMessages()}} and
\code{\link[base:suppressWarnings]{base::suppressWarnings()}}.
\item Bare conditions signalled with \code{signal()} or \code{\link[=cnd_signal]{cnd_signal()}}. Note
that conditions signalled with \code{\link[base:signalCondition]{base::signalCondition()}} are not
mufflable.
\item Interrupts are sometimes signalled with a \code{resume} restart on
recent R versions. When this is the case, you can muffle the
interrupt with \code{cnd_muffle()}. Check if a restart is available
with \code{base::findRestart("resume")}.
}

If you call \code{cnd_muffle()} with a condition that is not mufflable
you will cause a new error to be signalled.
\itemize{
\item Errors are not mufflable since they are signalled in critical
situations where execution cannot continue safely.
\item Conditions captured with \code{\link[base:tryCatch]{base::tryCatch()}}, \code{\link[=with_handlers]{with_handlers()}} or
\code{\link[=catch_cnd]{catch_cnd()}} are no longer mufflable. Muffling restarts \emph{must}
be called from a \link{calling} handler.
}
}

\examples{
fn <- function() {
  inform("Beware!", "my_particular_msg")
  inform("On your guard!")
  "foobar"
}

# Let's install a muffling handler for the condition thrown by `fn()`.
# This will suppress all `my_particular_wng` warnings but let other
# types of warnings go through:
with_handlers(fn(),
  my_particular_msg = calling(function(cnd) {
    inform("Dealt with this particular message")
    cnd_muffle(cnd)
  })
)

# Note how execution of `fn()` continued normally after dealing
# with that particular message.

# Since cnd_muffle() is a calling handler itself, it can also be
# passed to with_handlers() directly:
with_handlers(fn(),
  my_particular_msg = cnd_muffle
)
}
