% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{Matern.Kernel}
\alias{Matern.Kernel}
\title{Generalized Matern Kernel}
\usage{
Matern.Kernel(lengthscale, nu = 2.01)
}
\arguments{
\item{lengthscale}{a vector for the positive length scale parameters}

\item{nu}{a positive scalar parameter that controls the smoothness}
}
\value{
A Generalized Matern Kernel Class Object.
}
\description{
This function specifies the (Generalized) Matern kernel with any smoothness parameter \eqn{\nu}{nu}.
}
\details{
The Generalized Matern kernel is given by 
\deqn{k(r;\nu)=\frac{2^{1-\nu}}{\Gamma(\nu)}(\sqrt{2\nu}r)^{\nu}K_{\nu}(\sqrt{2\nu}r),}{k(r;nu) = 2^(1-nu) / Gamma(nu) * (sqrt(2*nu)*r)^(nu) * K_nu(sqrt(2*nu)*r),}
where \eqn{\nu}{nu} is the smoothness parameter, 
\eqn{K_{\nu}}{K_nu} is the modified Bessel function, 
\eqn{\Gamma}{Gamma} is the gamma function, 
and \deqn{r(x,x^{\prime})=\sqrt{\sum_{i=1}^{p}\left(\frac{x_{i}-x_{i}^{\prime}}{l_{i}}\right)^2}}{r(x,x') = sqrt(sum_{i=1}^{p} [(x_i - x'_i) / l_i]^2)} 
is the euclidean distance between \eqn{x}{x} and \eqn{x^{\prime}}{x'} weighted by
the length scale parameters \eqn{l_{i}}{l_i}'s. 
As \eqn{\nu\to\infty}{nu goes to infinity}, it converges to the \link{Gaussian.Kernel}.
}
\examples{
n <- 5
p <- 3
X <- matrix(rnorm(n*p), ncol=p)
lengthscale <- c(1:p)

# approach 1
kernel <- Matern.Kernel(lengthscale, nu=2.01)
Evaluate.Kernel(kernel, X)

# approach 2
kernel <- Get.Kernel(lengthscale, type="Matern", parameters=list(nu=2.01))
Evaluate.Kernel(kernel, X) 

}
\references{
Duvenaud, D. (2014). \emph{The kernel cookbook: Advice on covariance functions}.

Rasmussen, C. E. & Williams, C. K. (2006). \emph{Gaussian Processes for Machine Learning}. The MIT Press.
}
\seealso{
\link{Matern12.Kernel}, \link{Matern32.Kernel}, \link{Matern52.Kernel}, 
\link{MultiplicativeMatern.Kernel}, \link{Get.Kernel}, \link{Evaluate.Kernel}.
}
\author{
Chaofan Huang and V. Roshan Joseph
}
