% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/riverdist_1.R
\name{trimtopoints}
\alias{trimtopoints}
\title{Trim a River Network to a Set of X-Y Coordinates}
\usage{
trimtopoints(x, y, rivers, method = "snap", dist = NULL)
}
\arguments{
\item{x}{Vector of x-coordinates of point data to buffer around}

\item{y}{Vector of y-coordinates of point data to buffer around}

\item{rivers}{The river network object to use}

\item{method}{Three methods are available.  If \code{"snap"} is specified
(the default), only the closest segment to each point is retained.   If
\code{"snaproute"} is specified, segments are also retained that will
maintain total connectivity in the resulting river network.  If
\code{"buffer"} is specified, all segments with endpoints or midpoints
within \code{dist} units of the input locations are retained.}

\item{dist}{Distance to use for buffering, if \code{method="buffer"}.  If
this is not specified, the maximum spread in the x- and y- direction will
be used.}
}
\value{
A new river network object (see \link{rivernetwork})
}
\description{
Removes line segments from a river network object that are not
  adjacent to a set of point data, given in X-Y coordinates.
}
\note{
If \code{method=="buffer"}, only distances to segment endpoints 
  and midpoints are checked, and still only whole segments are removed.
}
\examples{
data(Koyukuk2)
x <- c(139241.0, 139416.1, 124600.1, 122226.8)
y <- c(1917577, 1913864, 1898723, 1898792)

plot(x=Koyukuk2)
points(x, y, pch=15, col=4)
legend(par("usr")[1], par("usr")[4], legend="points to buffer around", pch=15, col=4, cex=.6)

Koyukuk2.buf1 <- trimtopoints(x, y, rivers=Koyukuk2, method="snap")
plot(x=Koyukuk2.buf1)
points(x, y, pch=15, col=4)

Koyukuk2.buf2 <- trimtopoints(x, y, rivers=Koyukuk2, method="snaproute")
plot(x=Koyukuk2.buf2)
points(x, y, pch=15, col=4)

Koyukuk2.buf3 <- trimtopoints(x, y, rivers=Koyukuk2, method="buffer", dist=1000)
plot(x=Koyukuk2.buf3)
points(x, y, pch=15, col=4)
}
\author{
Matt Tyers
}
\seealso{
\link{line2network}
}

